(function(){
  function haptic(){ if("vibrate" in navigator) navigator.vibrate(12); }
  function toast(msg){
    const el = document.getElementById("toast");
    if(!el) return;
    el.textContent = msg;
    el.classList.add("show");
    clearTimeout(window.__toastTimer);
    window.__toastTimer = setTimeout(()=> el.classList.remove("show"), 1100);
  }
  async function getUser(){
    const saved = localStorage.getItem("sendzim_user");
    if(saved) return JSON.parse(saved);
    return { name: "User" };
  }
  async function setUserUI(){
    const u = await getUser();
    const nameEl = document.getElementById("userName");
    if(nameEl) nameEl.textContent = (u && u.name) ? u.name : "User";
    const settingsName = document.getElementById("settingsName");
    if(settingsName) settingsName.value = (u && u.name) ? u.name : "";
  }
  function setActiveNav(key){
    document.querySelectorAll(".navItem").forEach(b=>b.classList.remove("active"));
    const active = document.querySelector('.navItem[data-key="'+key+'"]');
    if(active) active.classList.add("active");
  }
  window.SendZim = { haptic, toast, getUser, setUserUI, setActiveNav };
})();
