<?php
declare(strict_types=1);
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
$u = require_admin();
csrf_token();
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$send_curs = ['USDT','USD','EUR','GBP'];
$methods = ['ANY','USDT','EcoCash','InnBucks'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $sc = (string)($_POST['send_currency'] ?? '');
  $rm = (string)($_POST['receive_method'] ?? 'ANY');
  $fee = (float)($_POST['fee_amount'] ?? 0);
  if (in_array($sc, $send_curs, true) && in_array($rm, $methods, true) && $fee >= 0) {
    db_exec("INSERT INTO fee_rules(send_currency, receive_method, fee_amount) VALUES(?,?,?) ON DUPLICATE KEY UPDATE fee_amount=VALUES(fee_amount)",
      [$sc,$rm,$fee])->close();
  }
  header("Location: fees.php?saved=1"); exit;
}

$rows = db_all("SELECT send_currency, receive_method, fee_amount FROM fee_rules ORDER BY send_currency, receive_method");
?>
<!doctype html><html><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title>Admin • Fees</title>
<style>
  .formCard{background:#fff;border:1px solid rgba(15,23,42,.10);border-radius:18px;padding:14px}
  .input{font-size:16px;padding:12px 12px;border-radius:14px;border:1px solid rgba(15,23,42,.12);width:100%}
  .label{font-weight:950;color:rgba(15,23,42,.72);font-size:12px;margin:10px 2px 6px}
  table{width:100%;border-collapse:separate;border-spacing:0 10px}
  td,th{font-size:13px;text-align:left}
  .row{background:#fff;border:1px solid rgba(15,23,42,.10);border-radius:14px;padding:10px}
</style>
</head><body>
<div class="app"><div class="shell">
  <div class="topbar">
    <div class="brand"><div class="sub">Fees</div></div>
    <div class="icons"><a class="iconbtn" href="index.php" aria-label="Back" title="Back"><svg viewBox="0 0 24 24" fill="none"><path d="M15 18l-6-6 6-6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg></a></div>
  </div>
  <div class="content">
    <?php if(isset($_GET['saved'])): ?><div class="infoBar">Saved ✅</div><?php endif; ?>
    <form method="post" class="formCard">
      <?= csrf_field() ?>
      <div class="label">Send currency</div>
      <select class="input" name="send_currency"><?php foreach($send_curs as $c): ?><option value="<?= h($c) ?>"><?= h($c) ?></option><?php endforeach; ?></select>
      <div class="label">Receive method</div>
      <select class="input" name="receive_method"><?php foreach($methods as $m): ?><option value="<?= h($m) ?>"><?= h($m) ?></option><?php endforeach; ?></select>
      <div class="label">Fee amount (in send currency)</div>
      <input class="input" name="fee_amount" inputmode="decimal" placeholder="e.g. 2.99">
      <button class="primaryBtn" style="width:100%;margin-top:14px">Save fee rule</button>
    </form>

    <div style="height:12px"></div>
    <div class="card white">
      <div class="h2">Current rules</div>
      <table>
        <thead><tr><th>Send</th><th>Method</th><th>Fee</th></tr></thead>
        <tbody>
          <?php foreach($rows as $r): ?>
            <tr><td><?= h($r['send_currency']) ?></td><td><?= h($r['receive_method']) ?></td><td><?= h($r['fee_amount']) ?></td></tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div></div>
</body></html>
