<?php
declare(strict_types=1);
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
$u = require_admin();
csrf_token();
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $pairs = ['USDT_ZWL','USD_ZWL','EUR_ZWL','GBP_ZWL'];
  foreach ($pairs as $p) {
    $v = (string)($_POST[$p] ?? '');
    $rate = (float)$v;
    if ($rate <= 0) continue;
    db_exec("INSERT INTO fx_rates(pair, rate, updated_at) VALUES(?,?,NOW()) ON DUPLICATE KEY UPDATE rate=VALUES(rate), updated_at=NOW()", [$p, $rate])->close();
  }
  header("Location: rates.php?saved=1"); exit;
}
$rows = db_all("SELECT pair, rate, updated_at FROM fx_rates ORDER BY pair");
$map = { };
foreach($rows as $r){ $map[$r['pair']] = $r; }
?>
<!doctype html><html><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title>Admin • Rates</title>
<style>
  .formCard{background:#fff;border:1px solid rgba(15,23,42,.10);border-radius:18px;padding:14px}
  .input{font-size:16px;padding:12px 12px;border-radius:14px;border:1px solid rgba(15,23,42,.12);width:100%}
  .label{font-weight:950;color:rgba(15,23,42,.72);font-size:12px;margin:10px 2px 6px}
</style>
</head><body>
<div class="app"><div class="shell">
  <div class="topbar">
    <div class="brand"><div class="sub">FX rates</div></div>
    <div class="icons">
      <a class="iconbtn" href="index.php" aria-label="Back" title="Back">
        <svg viewBox="0 0 24 24" fill="none"><path d="M15 18l-6-6 6-6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
      </a>
    </div>
  </div>
  <div class="content">
    <?php if(isset($_GET['saved'])): ?><div class="infoBar">Saved ✅</div><?php endif; ?>
    <form method="post" class="formCard">
      <?= csrf_field() ?>
      <?php foreach(['USDT_ZWL'=>'USDT → ZWL','USD_ZWL'=>'USD → ZWL','EUR_ZWL'=>'EUR → ZWL','GBP_ZWL'=>'GBP → ZWL'] as $k=>$label): ?>
        <div class="label"><?= h($label) ?></div>
        <input class="input" name="<?= h($k) ?>" inputmode="decimal" value="<?= h($map[$k]['rate'] ?? '') ?>" placeholder="e.g. 800">
      <?php endforeach; ?>
      <button class="primaryBtn" style="width:100%;margin-top:14px">Update rates</button>
      <div class="muted" style="font-weight:850;margin-top:10px">Tip: these rates are used when a quote is created (locked for 5 minutes).</div>
    </form>
  </div>
</div></div>
</body></html>
