<?php
declare(strict_types=1);
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
$u = require_admin();
csrf_token();
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $tid = (int)($_POST['tid'] ?? 0);
  $status = (string)($_POST['status'] ?? '');
  $txid = trim((string)($_POST['txid'] ?? ''));
  $allowed = ['awaiting_payment','payment_submitted','processing','completed','cancelled'];
  if ($tid > 0 && in_array($status, $allowed, true)) {
    db_exec("UPDATE transfers SET status=?, payment_txid=?, updated_at=NOW() WHERE id=?", [$status, $txid ?: null, $tid])->close();
  }
  header("Location: transfers.php"); exit;
}

$rows = db_all("SELECT t.*, u.email, u.full_name, r.full_name AS receiver_name, r.phone AS receiver_phone
                FROM transfers t
                JOIN users u ON u.id=t.user_id
                LEFT JOIN receivers r ON r.id=t.receiver_id
                ORDER BY t.id DESC
                LIMIT 200");
?>
<!doctype html><html><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title>Admin • Transfers</title>
<style>
  .tcard{border:1px solid rgba(15,23,42,.10);border-radius:18px;padding:14px;background:#fff}
  .meta{color:rgba(15,23,42,.62);font-weight:850;font-size:12.5px;margin-top:4px}
  .row{display:flex;justify-content:space-between;gap:12px;align-items:flex-start}
  .pill{display:inline-flex;padding:6px 10px;border-radius:999px;border:1px solid rgba(124,58,237,.18);background:rgba(124,58,237,.08);font-weight:950;color:#5b21b6;font-size:12px}
  .input{font-size:14px;padding:10px 10px;border-radius:12px;border:1px solid rgba(15,23,42,.12);width:100%}
  .mini{padding:10px 12px;border-radius:12px;border:1px solid rgba(15,23,42,.12);background:#fff;font-weight:950}
</style>
</head><body>
<div class="app"><div class="shell">
  <div class="topbar">
    <div class="brand"><div class="sub">Transfers</div></div>
    <div class="icons"><a class="iconbtn" href="index.php" aria-label="Back" title="Back"><svg viewBox="0 0 24 24" fill="none"><path d="M15 18l-6-6 6-6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg></a></div>
  </div>
  <div class="content">
    <?php foreach($rows as $t): ?>
      <div class="tcard" style="margin-bottom:12px">
        <div class="row">
          <div>
            <div style="font-weight:950"><?= h($t['full_name']) ?> <span class="meta">(<?= h($t['email']) ?>)</span></div>
            <div class="meta">To: <?= h($t['receiver_name'] ?? 'Receiver') ?> <?= h($t['receiver_phone'] ?? '') ?> • <?= h($t['receive_method']) ?></div>
            <div class="meta">Send: <b><?= h($t['send_amount']) ?> <?= h($t['send_currency']) ?></b> • Fee: <?= h($t['fee_amount']) ?> • Rate: <?= h($t['fx_rate']) ?> • Receive: <b><?= h($t['receive_amount']) ?> <?= h($t['receive_currency']) ?></b></div>
            <div class="meta">TXID: <?= h($t['payment_txid'] ?? '—') ?></div>
          </div>
          <div class="pill"><?= h(str_replace('_',' ', $t['status'])) ?></div>
        </div>

        <form method="post" style="margin-top:10px;display:grid;gap:8px">
          <?= csrf_field() ?>
          <input type="hidden" name="tid" value="<?= (int)$t['id'] ?>">
          <div style="display:grid;grid-template-columns:1.2fr 1fr;gap:8px">
            <input class="input" name="txid" value="<?= h($t['payment_txid'] ?? '') ?>" placeholder="TXID / reference">
            <select class="input" name="status">
              <?php foreach(['awaiting_payment','payment_submitted','processing','completed','cancelled'] as $s): ?>
                <option value="<?= h($s) ?>" <?= $t['status']===$s?'selected':'' ?>><?= h($s) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <button class="mini" type="submit">Update</button>
        </form>
      </div>
    <?php endforeach; ?>
  </div>
</div></div>
</body></html>
