<?php
declare(strict_types=1);
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
start_app_session();

$cfg = app_config();
if (!empty($cfg['__missing_config'])) { die("Missing backend/config/config.php (copy config.sample.php)."); }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $email = trim((string)($_POST['email'] ?? ''));
  $pass  = (string)($_POST['password'] ?? '');
  $u = db_row("SELECT id, full_name, password_hash, is_admin FROM users WHERE email = ?", [$email]);
  if ($u && password_verify($pass, $u['password_hash'])) {
    $_SESSION['uid'] = (int)$u['id'];
    $_SESSION['is_admin'] = (int)$u['is_admin'] === 1;
    header("Location: ../home/index.html");
    exit;
  }
  $error = "Invalid email or password.";
}
?>
<!doctype html><html><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title>Login</title>
<style>.authWrap{max-width:560px;margin:0 auto;padding:16px}.input{font-size:16px}</style>
</head><body>
<div class="authWrap">
  <div class="card white">
    <div class="h2">Sign in</div>
    <p class="muted" style="margin-top:-2px;font-weight:850;color:var(--muted)">Use your account to send money.</p>
    <?php if($error): ?><div class="infoBar" style="border-color:rgba(239,68,68,.2);background:rgba(239,68,68,.06)"><?= htmlspecialchars($error) ?></div><?php endif; ?>
    <form method="post">
      <?= csrf_field() ?>
      <div class="field"><label>Email</label><input class="input" name="email" type="email" required></div>
      <div class="field"><label>Password</label><input class="input" name="password" type="password" required></div>
      <button class="primaryBtn" style="width:100%;margin-top:10px">Sign in</button>
      <div style="margin-top:12px;font-weight:900;color:var(--muted);text-align:center">
        New here? <a href="register.php" style="color:var(--brand);text-decoration:none">Create account</a>
      </div>
    </form>
  </div>
</div>
</body></html>
