<?php
declare(strict_types=1);
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
start_app_session();

$cfg = app_config();
if (!empty($cfg['__missing_config'])) { die("Missing backend/config/config.php (copy config.sample.php)."); }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $name = trim((string)($_POST['name'] ?? ''));
  $email = trim((string)($_POST['email'] ?? ''));
  $pass  = (string)($_POST['password'] ?? '');

  if ($name === '' || mb_strlen($name) > 80) $error = "Name required (max 80).";
  else if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $error = "Valid email required.";
  else if (strlen($pass) < 8) $error = "Password must be at least 8 characters.";
  else {
    $exists = db_row("SELECT id FROM users WHERE email = ?", [$email]);
    if ($exists) $error = "Email already registered.";
    else {
      $hash = password_hash($pass, PASSWORD_DEFAULT);
      db_exec("INSERT INTO users(full_name,email,password_hash,created_at) VALUES (?,?,?,NOW())", [$name,$email,$hash])->close();
      $u = db_row("SELECT id,is_admin FROM users WHERE email = ?", [$email]);
      $_SESSION['uid'] = (int)$u['id'];
      $_SESSION['is_admin'] = (int)$u['is_admin'] === 1;
      header("Location: ../home/index.html");
      exit;
    }
  }
}
?>
<!doctype html><html><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title>Create account</title>
<style>.authWrap{max-width:560px;margin:0 auto;padding:16px}.input{font-size:16px}</style>
</head><body>
<div class="authWrap">
  <div class="card white">
    <div class="h2">Create account</div>
    <p class="muted" style="margin-top:-2px;font-weight:850;color:var(--muted)">Start sending to Zimbabwe in minutes.</p>
    <?php if($error): ?><div class="infoBar" style="border-color:rgba(239,68,68,.2);background:rgba(239,68,68,.06)"><?= htmlspecialchars($error) ?></div><?php endif; ?>
    <form method="post">
      <?= csrf_field() ?>
      <div class="field"><label>Full name</label><input class="input" name="name" maxlength="80" required></div>
      <div class="field"><label>Email</label><input class="input" name="email" type="email" required></div>
      <div class="field"><label>Password</label><input class="input" name="password" type="password" minlength="8" required></div>
      <button class="primaryBtn" style="width:100%;margin-top:10px">Create account</button>
      <div style="margin-top:12px;font-weight:900;color:var(--muted);text-align:center">
        Already have an account? <a href="login.php" style="color:var(--brand);text-decoration:none">Sign in</a>
      </div>
    </form>
  </div>
</div>
</body></html>
