<?php
declare(strict_types=1);
require_once __DIR__ . '/../lib/auth.php';

header('Content-Type: application/json; charset=utf-8');
$u = current_user();
if (!$u) {
  http_response_code(401);
  echo json_encode(['ok'=>false]);
  exit;
}
echo json_encode([
  'ok'=>true,
  'user'=>[
    'id'=>(int)$u['id'],
    'name'=>$u['full_name'],
    'email'=>$u['email'],
  ]
]);
