<?php

declare(strict_types=1);
require_once __DIR__ . '/lib/db.php';
$lock = __DIR__ . '/.installed';
if (file_exists($lock)) { http_response_code(403); die('Install is locked. Delete backend/.installed to rerun.'); }

$cfg = app_config();
if (!empty($cfg['__missing_config'])) {
  echo "<h3>Missing config</h3><p>Create <code>backend/config/config.php</code> by copying <code>config.sample.php</code>.</p>";
  exit;
}
$sql = file_get_contents(__DIR__ . '/schema.sql');
$parts = array_filter(array_map('trim', preg_split('/;\s*\n/', $sql)));
foreach ($parts as $q) { if ($q !== '') db()->query($q . ';'); }
file_put_contents($lock, date('c'));
// Ensure newer columns exist (safe migration)
$db = db();
@$db->query("ALTER TABLE transfers ADD COLUMN notify_receiver TINYINT(1) NOT NULL DEFAULT 0");
@$db->query("ALTER TABLE transfers ADD COLUMN notify_sender TINYINT(1) NOT NULL DEFAULT 0");

echo "<h3>Installed ✅</h3><p>Register: <a href='../auth/register.php'>/auth/register.php</a></p>";
