<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';

function start_app_session(): void {
  $cfg = app_config();
  $name = $cfg['app']['session_name'] ?? 'SENDZIMSESS';
  if (session_status() === PHP_SESSION_NONE) { session_name($name); session_start(); }
}

function current_user(): ?array {
  start_app_session();
  if (empty($_SESSION['uid'])) return null;
  return db_row("SELECT id, full_name, email, created_at FROM users WHERE id = ?", [intval($_SESSION['uid'])]);
}

function require_login(): array {
  $u = current_user();
  if (!$u) { header("Location: ../auth/login.php"); exit; }
  return $u;
}

function require_admin(): array {
  $u = require_login();
  start_app_session();
  $is_admin = !empty($_SESSION['is_admin']) && intval($_SESSION['is_admin']) === 1;
  if (!$is_admin) { http_response_code(403); die('Forbidden'); }
  return $u;
}
