<?php
declare(strict_types=1);
require_once __DIR__ . '/auth.php';

function csrf_token(): string {
  start_app_session();
  if (empty($_SESSION['csrf_token']) || !is_string($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
  }
  return $_SESSION['csrf_token'];
}

function csrf_field(): string {
  $t = csrf_token();
  return '<input type="hidden" name="csrf_token" value="' . htmlspecialchars($t, ENT_QUOTES, 'UTF-8') . '">';
}

function csrf_check(): void {
  start_app_session();
  if ($_SERVER['REQUEST_METHOD'] !== 'POST') return;
  $sent = (string)($_POST['csrf_token'] ?? '');
  $sess = (string)($_SESSION['csrf_token'] ?? '');
  if ($sent === '' || $sess === '' || !hash_equals($sess, $sent)) {
    http_response_code(419);
    die('Session expired. Please refresh and try again.');
  }
}
