<?php
declare(strict_types=1);

function http_post_json(string $url, array $payload, array $headers = []): array {
  $ch = curl_init($url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload, JSON_UNESCAPED_SLASHES));
  curl_setopt($ch, CURLOPT_TIMEOUT, 12);

  $resp = curl_exec($ch);
  $err = curl_error($ch);
  $code = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  if ($resp === false) return ['ok'=>false,'status'=>$code,'error'=>$err ?: 'curl_error'];
  $json = json_decode($resp, true);
  if (!is_array($json)) $json = ['raw'=>$resp];
  return ['ok'=>($code>=200 && $code<300),'status'=>$code,'data'=>$json];
}
