<?php
declare(strict_types=1);

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/http.php';

function wa_enabled(): bool {
  $cfg = app_config();
  return !empty($cfg['whatsapp']['enabled'])
    && !empty($cfg['whatsapp']['access_token'])
    && !empty($cfg['whatsapp']['phone_number_id']);
}

/**
 * Send a WhatsApp template message (business-initiated).
 * $toE164NoPlus example: 263771234567
 */
function wa_send_template(string $toE164NoPlus, string $templateName, string $lang = 'en_US', array $components = []): array {
  $cfg = app_config();
  $token = $cfg['whatsapp']['access_token'] ?? '';
  $phoneNumberId = $cfg['whatsapp']['phone_number_id'] ?? '';
  if ($token === '' || $phoneNumberId === '') return ['ok'=>false,'error'=>'whatsapp_not_configured'];

  $url = "https://graph.facebook.com/v20.0/" . rawurlencode($phoneNumberId) . "/messages";
  $payload = [
    'messaging_product' => 'whatsapp',
    'to' => $toE164NoPlus,
    'type' => 'template',
    'template' => [
      'name' => $templateName,
      'language' => ['code' => $lang],
    ],
  ];
  if (!empty($components)) $payload['template']['components'] = $components;

  $headers = [
    "Authorization: Bearer {$token}",
    "Content-Type: application/json",
  ];
  return http_post_json($url, $payload, $headers);
}

function wa_body_params(array $params): array {
  $out = [];
  foreach ($params as $v) $out[] = ['type'=>'text','text'=>(string)$v];
  return [[ 'type' => 'body', 'parameters' => $out ]];
}
