<?php
declare(strict_types=1);
require_once __DIR__ . '/../lib/db.php';
function fee_for(string $send_currency, string $receive_method): float {
  $row = db_row("SELECT fee_amount FROM fee_rules WHERE send_currency=? AND receive_method=? LIMIT 1", [$send_currency, $receive_method]);
  if ($row) return (float)$row['fee_amount'];
  $row2 = db_row("SELECT fee_amount FROM fee_rules WHERE send_currency=? AND receive_method='ANY' LIMIT 1", [$send_currency]);
  if ($row2) return (float)$row2['fee_amount'];
  return 2.99;
}
