<?php
declare(strict_types=1);

require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/whatsapp.php';

/**
 * Sends WhatsApp confirmations after payment verification.
 * NOTE: You must have user opt-in to message them.
 */
function notify_after_payment_verified(int $transfer_id): void {
  if (!wa_enabled()) return;

  $t = db_row("SELECT t.*, r.full_name AS receiver_name, r.phone AS receiver_phone
               FROM transfers t
               JOIN receivers r ON r.id = t.receiver_id
               WHERE t.id = ?", [$transfer_id]);
  if (!$t) return;

  $cfg = app_config();
  $amount = number_format((float)$t['send_amount'], 2, '.', '');
  $sendCur = (string)$t['send_currency'];
  $method = (string)$t['receive_method'];
  $ref = (string)$t['quote_id'];

  // Receiver confirmation (optional, requires opt-in)
  if ((int)($t['notify_receiver'] ?? 0) !== 1) {
    // no opt-in
  } else {
  $receiver = preg_replace('/\D+/', '', (string)$t['receiver_phone']);
  if ($receiver !== '') {
    wa_send_template(
      $receiver,
      (string)($cfg['whatsapp']['template_transfer_created'] ?? 'sendzim_transfer_created'),
      'en_US',
      wa_body_params([$amount, $sendCur, $method, $ref])
    );
  }
  }

  // Admin notify (recommended)
  $admin = preg_replace('/\D+/', '', (string)($cfg['whatsapp']['admin_notify_number'] ?? ''));
  if ($admin !== '') {
    wa_send_template(
      $admin,
      (string)($cfg['whatsapp']['template_payment_confirmed'] ?? 'sendzim_payment_confirmed'),
      'en_US',
      wa_body_params([$amount, $sendCur, $t['receiver_name'], $method, $ref])
    );
  }
}
