<?php
declare(strict_types=1);
require_once __DIR__ . '/../lib/db.php';

function receivers_for_user(int $user_id): array {
  return db_all("SELECT * FROM receivers WHERE user_id=? ORDER BY id DESC", [$user_id]);
}

function receiver_get(int $user_id, int $rid): ?array {
  return db_row("SELECT * FROM receivers WHERE id=? AND user_id=?", [$rid, $user_id]);
}

function receiver_create(int $user_id, string $full_name, string $phone, string $city, string $method): int {
  db_exec("INSERT INTO receivers(user_id,full_name,phone,city,method,created_at,updated_at) VALUES (?,?,?,?,?,NOW(),NOW())",
    [$user_id,$full_name,$phone,$city,$method])->close();
  $row = db_row("SELECT LAST_INSERT_ID() AS id");
  return $row ? (int)$row['id'] : 0;
}

function receiver_update(int $user_id, int $rid, string $full_name, string $phone, string $city, string $method): void {
  db_exec("UPDATE receivers SET full_name=?, phone=?, city=?, method=?, updated_at=NOW() WHERE id=? AND user_id=?",
    [$full_name,$phone,$city,$method,$rid,$user_id])->close();
}

function receiver_delete(int $user_id, int $rid): void {
  db_exec("DELETE FROM receivers WHERE id=? AND user_id=?", [$rid,$user_id])->close();
}
