<?php
declare(strict_types=1);
require_once __DIR__ . '/../lib/db.php';
function create_quote(int $user_id, string $send_currency, string $receive_currency, float $send_amount, float $fx_rate, float $fee): string {
  $quote_id = bin2hex(random_bytes(16));
  $receive_amount = max(0, ($send_amount - $fee) * $fx_rate);
  $expires_at = date('Y-m-d H:i:s', time() + 300);
  db_exec(
    "INSERT INTO quotes (quote_id,user_id,send_currency,receive_currency,send_amount,fee_amount,fx_rate,receive_amount,expires_at,created_at)
     VALUES (?,?,?,?,?,?,?,?,?,NOW())",
    [$quote_id,$user_id,$send_currency,$receive_currency,$send_amount,$fee,$fx_rate,$receive_amount,$expires_at]
  )->close();
  return $quote_id;
}
function quote_by_id(string $quote_id): ?array {
  return db_row("SELECT * FROM quotes WHERE quote_id=?", [$quote_id]);
}
function list_transfers_for_user(int $user_id): array {
  $sql = "SELECT t.*, r.full_name AS receiver_name, r.phone AS receiver_phone
          FROM transfers t
          LEFT JOIN receivers r ON r.id = t.receiver_id
          WHERE t.user_id = ?
          ORDER BY t.id DESC
          LIMIT 50";
  return db_all($sql, [$user_id]);
}

function create_transfer_from_quote(string $quote_id, int $receiver_id, string $receive_method, string $reason, int $notify_receiver = 0, int $notify_sender = 0): int {
  $q = quote_by_id($quote_id);
  if (!$q) return 0;
  db_exec(
  // Build INSERT dynamically so older installs still work if columns are missing
  $cols = ['user_id','receiver_id','quote_id','send_currency','receive_currency','send_amount','fee_amount','fx_rate','receive_amount','receive_method','reason','status','created_at','updated_at'];
  $vals = [(int)$q['user_id'],$receiver_id,$quote_id,$q['send_currency'],$q['receive_currency'],$q['send_amount'],$q['fee_amount'],$q['fx_rate'],$q['receive_amount'],$receive_method,$reason,'awaiting_payment',date('Y-m-d H:i:s'),date('Y-m-d H:i:s')];
  if (db_has_column('transfers','notify_receiver')) { $cols[]='notify_receiver'; $vals[]=$notify_receiver ? 1 : 0; }
  if (db_has_column('transfers','notify_sender')) { $cols[]='notify_sender'; $vals[]=$notify_sender ? 1 : 0; }
  $placeholders = implode(',', array_fill(0, count($cols), '?'));
  $sql = "INSERT INTO transfers (".implode(',', $cols).") VALUES ($placeholders)";
  db_exec($sql, $vals)->close();
  $row = db_row("SELECT LAST_INSERT_ID() AS id");
  return $row ? (int)$row['id'] : 0;
}