CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  full_name VARCHAR(80) NOT NULL,
  email VARCHAR(120) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  is_admin TINYINT(1) NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS receivers (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  full_name VARCHAR(40) NOT NULL,
  phone VARCHAR(20) NOT NULL,
  city VARCHAR(40) NOT NULL,
  method VARCHAR(30) NOT NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  INDEX(user_id),
  CONSTRAINT fk_receivers_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS fx_rates (
  pair VARCHAR(20) PRIMARY KEY,
  rate DECIMAL(18,8) NOT NULL,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS fee_rules (
  id INT AUTO_INCREMENT PRIMARY KEY,
  send_currency VARCHAR(10) NOT NULL,
  receive_method VARCHAR(30) NOT NULL,
  fee_amount DECIMAL(18,8) NOT NULL,
  UNIQUE KEY uniq_fee (send_currency, receive_method)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS quotes (
  id INT AUTO_INCREMENT PRIMARY KEY,
  quote_id CHAR(32) NOT NULL UNIQUE,
  user_id INT NOT NULL,
  send_currency VARCHAR(10) NOT NULL,
  receive_currency VARCHAR(10) NOT NULL,
  send_amount DECIMAL(18,8) NOT NULL,
  fee_amount DECIMAL(18,8) NOT NULL,
  fx_rate DECIMAL(18,8) NOT NULL,
  receive_amount DECIMAL(18,8) NOT NULL,
  expires_at DATETIME NOT NULL,
  created_at DATETIME NOT NULL,
  INDEX(user_id),
  CONSTRAINT fk_quotes_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS transfers (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  receiver_id INT NOT NULL,
  quote_id CHAR(32) NOT NULL,
  send_currency VARCHAR(10) NOT NULL,
  receive_currency VARCHAR(10) NOT NULL,
  send_amount DECIMAL(18,8) NOT NULL,
  fee_amount DECIMAL(18,8) NOT NULL,
  fx_rate DECIMAL(18,8) NOT NULL,
  receive_amount DECIMAL(18,8) NOT NULL,
  receive_method VARCHAR(30) NOT NULL,
  reason VARCHAR(40) NOT NULL,
  status VARCHAR(24) NOT NULL,
  payment_txid VARCHAR(120) NULL,
  notify_receiver TINYINT(1) NOT NULL DEFAULT 0,
  notify_sender TINYINT(1) NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL,
  INDEX(user_id),
  INDEX(receiver_id),
  INDEX(status),
  CONSTRAINT fk_transfers_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
  CONSTRAINT fk_transfers_receiver FOREIGN KEY (receiver_id) REFERENCES receivers(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO fx_rates(pair, rate) VALUES
('USDT_ZWL', 800.0),
('USD_ZWL', 800.0),
('EUR_ZWL', 900.0),
('GBP_ZWL', 1050.0)
ON DUPLICATE KEY UPDATE rate=VALUES(rate), updated_at=NOW();

INSERT INTO fee_rules(send_currency, receive_method, fee_amount) VALUES
('EUR','ANY', 2.99),
('GBP','ANY', 2.99),
('USD','ANY', 2.99),
('USDT','ANY', 1.00)
ON DUPLICATE KEY UPDATE fee_amount=VALUES(fee_amount);
