<?php
declare(strict_types=1);
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
require_once __DIR__ . '/../backend/models/receivers.php';
$u = require_login();
csrf_token();

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $action = (string)($_POST['action'] ?? '');
  $rid = (int)($_POST['rid'] ?? 0);
  if ($action === 'delete' && $rid > 0) {
    receiver_delete((int)$u['id'], $rid);
    header("Location: index.php");
    exit;
  }
}

$rows = receivers_for_user((int)$u['id']);
?>
<!doctype html><html><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title>Receivers</title>
<style>
  .rxCard{border:1px solid rgba(15,23,42,.10);border-radius:18px;padding:14px;background:#fff}
  .rxTop{display:flex;align-items:flex-start;justify-content:space-between;gap:10px}
  .rxName{font-weight:950;font-size:16px;letter-spacing:-.2px}
  .rxMeta{color:rgba(15,23,42,.65);font-weight:850;font-size:13px;margin-top:3px}
  .btnRow{display:flex;gap:10px;margin-top:10px}
  .miniBtn{display:inline-flex;align-items:center;justify-content:center;gap:8px;border-radius:14px;border:1px solid rgba(15,23,42,.12);padding:10px 12px;background:#fff;font-weight:950;text-decoration:none;color:rgba(15,23,42,.88)}
  .miniBtn:hover{background:rgba(124,58,237,.05);border-color:rgba(124,58,237,.18)}
  .danger{border-color:rgba(239,68,68,.25);color:rgba(153,27,27,.9)}
  .danger:hover{background:rgba(239,68,68,.06)}
  .fab{position:fixed;right:16px;bottom:88px;z-index:20}
  .fab a{display:inline-flex;align-items:center;gap:10px;border-radius:999px;padding:12px 14px;background:var(--brand);color:#fff;text-decoration:none;font-weight:950;box-shadow:0 14px 34px rgba(124,58,237,.28)}
  .fab svg{width:18px;height:18px}
</style>
</head><body>
<div class="app"><div class="shell">
  <div class="topbar">
    <div class="brand"><div class="sub">Receivers</div></div>
    <div class="icons">
      <a class="iconbtn" href="../settings/index.html" aria-label="Settings" title="Settings">
        <svg viewBox="0 0 24 24" fill="none"><path d="M12 15.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7Z" stroke="currentColor" stroke-width="2"/><path d="M19.4 15a7.8 7.8 0 0 0 .1-2l2-1.5-2-3.5-2.4 1a8 8 0 0 0-1.7-1L15 4h-6l-.4 2.5c-.6.3-1.2.6-1.7 1l-2.4-1-2 3.5 2 1.5a7.8 7.8 0 0 0 0 2l-2 1.5 2 3.5 2.4-1c.5.4 1.1.7 1.7 1L9 20h6l.4-2.5c.6-.3 1.2-.6 1.7-1l2.4 1 2-3.5-2-1.5Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/></svg>
      </a>
    </div>
  </div>

  <div class="content">
    <?php if (!$rows): ?>
      <div class="card white">
        <div class="h2">No receivers yet</div>
        <p class="muted">Add a receiver in Zimbabwe to send money fast.</p>
        <a class="primaryBtn" href="new.php" style="width:100%;text-align:center;text-decoration:none">Add new receiver</a>
      </div>
    <?php else: ?>
      <div class="grid" style="gap:12px">
        <?php foreach($rows as $r): ?>
          <div class="rxCard">
            <div class="rxTop">
              <div>
                <div class="rxName"><?= h($r['full_name']) ?></div>
                <div class="rxMeta"><?= h($r['phone']) ?> • <?= h($r['city']) ?> • <?= h($r['method']) ?></div>
              </div>
              <div class="pill" style="background:rgba(124,58,237,.08);border:1px solid rgba(124,58,237,.18);color:#5b21b6">Saved</div>
            </div>
            <div class="btnRow">
              <a class="miniBtn" href="new.php?edit=<?= (int)$r['id'] ?>">Edit</a>
              <form method="post" style="margin:0;flex:1" onsubmit="return confirm('Delete this receiver?')">
                <?= csrf_field() ?>
                <input type="hidden" name="action" value="delete"/>
                <input type="hidden" name="rid" value="<?= (int)$r['id'] ?>"/>
                <button class="miniBtn danger" type="submit" style="width:100%">Delete</button>
              </form>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>

  <div class="fab">
    <a href="new.php">
      <svg viewBox="0 0 24 24" fill="none"><path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
      Add receiver
    </a>
  </div>

  <?php include __DIR__ . '/../partials/bottom_nav.php'; ?>
</div></div>
<script src="../assets/app.js"></script>
<script>SendZim.setActiveNav("receivers");SendZim.setUserUI();</script>
</body></html>
