<?php
declare(strict_types=1);
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
require_once __DIR__ . '/../backend/models/receivers.php';
$u = require_login();
csrf_token();

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function norm_phone(string $digits): string {
  $digits = preg_replace('/\D+/', '', $digits) ?? '';
  if (strlen($digits) > 9) $digits = substr($digits, -9);
  return $digits;
}

$editId = isset($_GET['edit']) ? (int)$_GET['edit'] : 0;
$existing = $editId ? receiver_get((int)$u['id'], $editId) : null;

$errors = [];
$full_name = $existing['full_name'] ?? '';
$city = $existing['city'] ?? '';
$method = $existing['method'] ?? 'EcoCash';
$phone_digits = $existing ? preg_replace('/^\+?263/', '', (string)$existing['phone']) : '';

$allowed_methods = ['USDT','EcoCash','InnBucks'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $full_name = trim((string)($_POST['full_name'] ?? ''));
  $city = trim((string)($_POST['city'] ?? ''));
  $method = (string)($_POST['method'] ?? 'EcoCash');
  $phone_digits = norm_phone((string)($_POST['phone_digits'] ?? ''));

  if ($full_name === '' || mb_strlen($full_name) > 40) $errors[] = "Full name is required (max 40 characters).";
  if ($city === '' || mb_strlen($city) > 40) $errors[] = "City/Town is required (max 40 characters).";
  if (!in_array($method, $allowed_methods, true)) $errors[] = "Invalid receive method.";
  if (strlen($phone_digits) !== 9) $errors[] = "Phone must be 9 digits (Zimbabwe).";

  if (!$errors) {
    $phone = "+263" . $phone_digits;
    if ($existing) {
      receiver_update((int)$u['id'], (int)$existing['id'], $full_name, $phone, $city, $method);
    } else {
      receiver_create((int)$u['id'], $full_name, $phone, $city, $method);
    }
    header("Location: index.php");
    exit;
  }
}
?>
<!doctype html><html><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title><?= $existing ? "Edit receiver" : "New receiver" ?></title>
<style>
  .pageHead{display:flex;align-items:center;gap:12px;padding:10px 6px 10px}
  .back{width:44px;height:44px;border-radius:14px;border:1px solid rgba(15,23,42,.12);display:grid;place-items:center;background:#fff;text-decoration:none;color:rgba(15,23,42,.8)}
  .back:hover{background:rgba(124,58,237,.05);border-color:rgba(124,58,237,.18);color:#5b21b6}
  .title{font-size:18px;font-weight:950;letter-spacing:-.2px;margin:0}
  .formCard{background:#fff;border:1px solid rgba(15,23,42,.10);border-radius:20px;padding:14px}
  .input{font-size:16px;padding:12px 12px;border-radius:14px;border:1px solid rgba(15,23,42,.12);width:100%;outline:none}
  .input:focus{border-color:rgba(124,58,237,.55);box-shadow:0 0 0 4px rgba(124,58,237,.12)}
  .row{display:grid;gap:10px}
  .label{font-weight:950;color:rgba(15,23,42,.72);font-size:12px;margin:10px 2px 6px}
  .phoneRow{display:flex;gap:10px;align-items:center}
  .prefix{flex:0 0 auto;padding:12px 12px;border-radius:14px;border:1px solid rgba(15,23,42,.12);background:rgba(124,58,237,.06);color:#5b21b6;font-weight:950}
  .select{appearance:none;background:#fff}
  .hint{color:rgba(15,23,42,.55);font-weight:850;font-size:12px;margin-top:6px}
  .err{border:1px solid rgba(239,68,68,.18);background:rgba(239,68,68,.06);padding:10px 12px;border-radius:16px;font-weight:900;color:rgba(153,27,27,.92)}
</style>
</head><body>
<div class="app"><div class="shell">
  <div class="pageHead">
    <a class="back" href="index.php" aria-label="Back">
      <svg viewBox="0 0 24 24" fill="none"><path d="M15 18l-6-6 6-6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
    </a>
    <div>
      <h1 class="title"><?= $existing ? "Edit receiver" : "Add new receiver" ?></h1>
      <div class="muted" style="font-weight:900">Saved to your account for faster transfers.</div>
    </div>
  </div>

  <div class="content">
    <?php if($errors): ?>
      <div class="err"><?= h(implode(" ", $errors)) ?></div>
      <div style="height:10px"></div>
    <?php endif; ?>

    <form method="post" class="formCard">
      <?= csrf_field() ?>
      <div class="label">Full name (max 40 chars)</div>
      <input class="input" name="full_name" maxlength="40" value="<?= h($full_name) ?>" required>

      <div class="label">Phone number</div>
      <div class="phoneRow">
        <div class="prefix">+263</div>
        <input class="input" style="flex:1" inputmode="numeric" pattern="\d{9}" maxlength="9" name="phone_digits" value="<?= h($phone_digits) ?>" placeholder="771234567" required>
      </div>
      <div class="hint">Enter the remaining 9 digits after +263.</div>

      <div class="label">City / Town (max 40 chars)</div>
      <input class="input" name="city" maxlength="40" value="<?= h($city) ?>" required>

      <div class="label">Preferred receive method</div>
      <select class="input select" name="method" required>
        <?php foreach($allowed_methods as $m): ?>
          <option value="<?= h($m) ?>" <?= $method===$m?'selected':'' ?>><?= h($m) ?></option>
        <?php endforeach; ?>
      </select>

      <button class="primaryBtn" style="width:100%;margin-top:14px"><?= $existing ? "Save changes" : "Save receiver" ?></button>
    </form>
  </div>

  <?php include __DIR__ . '/../partials/bottom_nav.php'; ?>
</div></div>
<script src="../assets/app.js"></script>
<script>SendZim.setActiveNav("receivers");SendZim.setUserUI();</script>
</body></html>
