<?php
require_once __DIR__ . '/../backend/lib/auth.php';
$u = require_login();
// components/receive_method.php — Bottom-sheet selector (mobile-first, tappable above footer)
?>
<div class="sectionTitle">RECEIVE METHOD</div>

<!-- Trigger -->
<div class="card" style="padding:12px;">
  <button type="button" class="selectRow rmTrigger" id="methodBtn" aria-haspopup="dialog" aria-controls="rmOverlay">
    <div class="left rmTriggerLeft">
      <div class="iconBadge rmTriggerBadge" id="methodIcon">
        <img alt="USDT" src="https://i.imgur.com/rDkAovM.png"
             onerror="this.remove(); this.parentElement.innerHTML = window.__fallbackIcon('USDT')">
      </div>
      <div class="rmTriggerText">
        <span id="methodText" class="rmTriggerMain">USDT</span>
        <span class="rmTriggerSub">Tap choose receiver gets paid</span>
      </div>
    </div>
    <svg class="chev rmTriggerChev" viewBox="0 0 24 24" fill="none" aria-hidden="true">
      <path d="M7 10l5 5 5-5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  </button>
</div>

<!-- Bottom sheet -->
<div id="rmOverlay" class="rmOverlay" aria-hidden="true">
  <div class="rmBackdrop" data-close="1"></div>

  <div class="rmSheet" role="dialog" aria-modal="true" aria-label="Receive method">
    <div class="rmTop">
      <button class="rmClose" type="button" aria-label="Close" data-close="1">
        <svg viewBox="0 0 24 24" fill="none"><path d="M18 6L6 18M6 6l12 12" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
      </button>
      <div class="rmTitle">Receive method</div>
      <div style="width:40px"></div>
    </div>

    <div class="rmList">
      <button type="button" class="rmItem" data-method="USDT" data-icon="https://i.imgur.com/rDkAovM.png">
        <span class="rmLogo"><img alt="USDT" src="https://i.imgur.com/rDkAovM.png"></span>
        <span class="rmTxt">
          <span class="rmName">USDT</span>
          <span class="rmMeta">Crypto payout (fast)</span>
        </span>
        <span class="rmCheck"></span>
      </button>

      <button type="button" class="rmItem" data-method="EcoCash" data-icon="https://i.imgur.com/mEy6liY.png">
        <span class="rmLogo"><img alt="EcoCash" src="https://i.imgur.com/mEy6liY.png"></span>
        <span class="rmTxt">
          <span class="rmName">Mobile Money — EcoCash</span>
          <span class="rmMeta">Instant wallet payout</span>
        </span>
        <span class="rmCheck"></span>
      </button>

      <button type="button" class="rmItem" data-method="InnBucks" data-icon="https://i.imgur.com/Xd2DK8s.png">
        <span class="rmLogo"><img alt="InnBucks" src="https://i.imgur.com/Xd2DK8s.png"></span>
        <span class="rmTxt">
          <span class="rmName">Mobile Money — InnBucks</span>
          <span class="rmMeta">Instant wallet payout</span>
        </span>
        <span class="rmCheck"></span>
      </button>
    </div>
  </div>
</div>

<style>
/* Always above footer bar (footer is typically z-index ~40 in send flow) */
.rmOverlay{position:fixed;inset:0;z-index:220;display:none}
.rmOverlay.open{display:block}
.rmBackdrop{position:absolute;inset:0;background:rgba(17,24,39,.46);backdrop-filter:saturate(120%) blur(2px)}

/* DARK PURPLE premium trigger block (matches your currency blocks) */
.rmTrigger{
  width:100%;
  border:1px solid rgba(255,255,255,.06);
  border-radius:22px;
  padding:18px 18px;
  background:radial-gradient(120% 140% at 10% 10%, rgba(255,255,255,.10) 0%, rgba(255,255,255,0) 55%),
             linear-gradient(135deg,#2b0a4a,#1f0a33);
  color:#fff;
  display:flex;
  align-items:center;
  justify-content:space-between;
  gap:14px;
  box-shadow:0 18px 40px rgba(31,10,51,.20);
}
.rmTriggerLeft{display:flex;align-items:center;gap:12px;min-width:0}
.rmTriggerBadge{
  width:40px;height:40px;
  border-radius:999px;
  overflow:hidden;
  border:2px solid rgba(255,255,255,.22);
  background:rgba(255,255,255,.08);
  display:grid;place-items:center;
  flex:0 0 auto;
}
.rmTriggerBadge img{width:100%;height:100%;object-fit:cover;display:block}
.rmTriggerText{display:flex;flex-direction:column;gap:3px;min-width:0;line-height:1.15}
.rmTriggerMain{font-size:20px;font-weight:950;letter-spacing:-.2px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
.rmTriggerSub{font-size:13px;font-weight:900;color:rgba(255,255,255,.78);white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
.rmTriggerChev{width:22px;height:22px;opacity:.9}

.rmSheet{
  position:absolute;left:50%;transform:translateX(-50%);
  bottom:0;width:min(var(--maxw),100%);
  background:#fff;border-radius:22px 22px 0 0;
  border:1px solid rgba(230,232,238,.75);
  box-shadow:0 -22px 60px rgba(16,24,40,.18);
  padding:10px 14px calc(14px + var(--safeBottom));
}
.rmTop{display:flex;align-items:center;justify-content:space-between;gap:10px;padding:6px 2px 10px}
.rmClose{width:40px;height:40px;border-radius:14px;border:1px solid transparent;background:rgba(124,58,237,.06);color:var(--brand);display:grid;place-items:center;cursor:pointer}
.rmClose svg{width:20px;height:20px}
.rmTitle{font-weight:950;font-size:18px;letter-spacing:-.2px}
.rmList{display:grid;gap:10px}
.rmItem{
  width:100%;border:1px solid var(--stroke);border-radius:18px;background:#fff;
  display:flex;align-items:center;gap:12px;padding:14px 12px;cursor:pointer;
  text-align:left;transition:transform .12s ease, border-color .12s ease, background .12s ease;
}
.rmItem:active{transform:scale(.99)}
.rmLogo{width:44px;height:44px;border-radius:16px;background:var(--soft);display:grid;place-items:center;border:1px solid rgba(0,0,0,.06);overflow:hidden;flex:0 0 auto}
.rmLogo img{width:100%;height:100%;object-fit:cover;display:block}
.rmTxt{display:flex;flex-direction:column;gap:2px;min-width:0}
.rmName{font-weight:950;font-size:16px;line-height:1.15}
.rmMeta{font-weight:900;color:var(--muted);font-size:12.5px}
.rmCheck{width:22px;height:22px;border-radius:999px;border:2px solid rgba(124,58,237,.25);margin-left:auto;flex:0 0 auto}
.rmItem.active{border-color:rgba(124,58,237,.55);background:rgba(124,58,237,.06)}
.rmItem.active .rmCheck{background:var(--brand);border-color:var(--brand);box-shadow:0 10px 18px rgba(124,58,237,.22)}

@media (max-width:420px){
  .rmTrigger{padding:16px 16px;border-radius:20px}
  .rmTriggerMain{font-size:19px}
}
</style>

<script>
(function(){
  const overlay = document.getElementById('rmOverlay');
  const btn = document.getElementById('methodBtn');
  const text = document.getElementById('methodText');
  const iconWrap = document.getElementById('methodIcon');
  if (!overlay || !btn || !text || !iconWrap) return;

  function openSheet(){
    overlay.classList.add('open');
    overlay.setAttribute('aria-hidden','false');
    document.body.style.overflow = 'hidden';
    setActive(text.textContent.trim());
    if ('vibrate' in navigator) navigator.vibrate(10);
  }
  function closeSheet(){
    overlay.classList.remove('open');
    overlay.setAttribute('aria-hidden','true');
    document.body.style.overflow = '';
  }

  function setActive(method){
    overlay.querySelectorAll('.rmItem').forEach(it=>{
      it.classList.toggle('active', it.dataset.method === method);
    });
  }

  btn.addEventListener('click', (e)=>{ e.preventDefault(); openSheet(); });
  overlay.addEventListener('click', (e)=>{
    const close = e.target && e.target.getAttribute && e.target.getAttribute('data-close');
    if (close) closeSheet();
  });
  document.addEventListener('keydown', (e)=>{ if (e.key === 'Escape') closeSheet(); });

  overlay.querySelectorAll('.rmItem').forEach(it=>{
    it.addEventListener('click', ()=>{
      const method = it.dataset.method;
      const icon = it.dataset.icon;

      text.textContent = method;
      iconWrap.innerHTML = '<img alt="'+method+'" src="'+icon+'" onerror="this.remove(); this.parentElement.innerHTML = window.__fallbackIcon(\''+method+'\')">';
      setActive(method);

      // Notify parent page to resync fees/totals
      if (typeof window.onReceiveMethodChange === 'function') {
        window.onReceiveMethodChange(method);
      }

      closeSheet();
      if (typeof window.toast === 'function') window.toast("Receive method: " + method);
      if ('vibrate' in navigator) navigator.vibrate(12);
    });
  });
})();
</script>
