<?php
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
csrf_token();
$u = require_login();
require_once __DIR__ . '/../backend/models/rates.php';
require_once __DIR__ . '/../backend/models/fees.php';
require_once __DIR__ . '/../backend/models/transfers.php';
// next.php — SendZim "Recipient details" (Step 2)
// Keeps your original Recipient Details UI.
// After Continue: saves into session and redirects to review.php (Step 3).

if (!isset($_SESSION['user_name']) || trim($_SESSION['user_name']) === '') {
  $_SESSION['user_name'] = "User";
}
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }


/**
 * Create/refresh quote from step1 POST (server-side)
 * We lock FX+fee for 5 minutes and store quote_id in session.
 */
$posted = ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['send_currency'], $_POST['send_amount']));
if ($posted) {
  $sendCur = strtoupper(trim((string)($_POST['send_currency'] ?? 'USDT')));
  $sendAmt = (float)($_POST['send_amount'] ?? 0);
  $method  = trim((string)($_POST['receive_method'] ?? 'USDT'));

  // Canonical receive currency for Zimbabwe (ZWL)
  $recvCur = 'ZWL';
  $pair = $sendCur . '_ZWL';

  $fx = fx_rate($pair, 0.0);
  if ($fx <= 0) { $fx = 800.0; } // safe fallback

  $fee = fee_for($sendCur, $method);
  $quote_id = create_quote((int)$u['id'], $sendCur, $recvCur, $sendAmt, $fx, $fee);

  $_SESSION['transfer'] = $_SESSION['transfer'] ?? [];
  $_SESSION['transfer']['quote_id'] = $quote_id;
  $_SESSION['transfer']['send_currency'] = $sendCur;
  $_SESSION['transfer']['send_amount'] = $sendAmt;
  $_SESSION['transfer']['receive_currency'] = $recvCur;
  $_SESSION['transfer']['receive_method'] = $method;
  $_SESSION['transfer']['fee_amount'] = $fee;
  $_SESSION['transfer']['fx_rate'] = $fx;
  $_SESSION['transfer']['receive_amount'] = max(0, ($sendAmt - $fee) * $fx);
}

$sendCur = $_POST['send_currency'] ?? ($_SESSION['draft_transfer']['send_currency'] ?? 'USDT');
$sendAmt = (float)($_POST['send_amount'] ?? ($_SESSION['draft_transfer']['send_amount'] ?? 0));
$recvCur = $_POST['receive_currency'] ?? ($_SESSION['draft_transfer']['receive_currency'] ?? 'USD');
$recvAmt = (float)($_POST['receive_amount'] ?? ($_SESSION['draft_transfer']['receive_amount'] ?? 0));
$method  = trim($_POST['receive_method'] ?? ($_SESSION['draft_transfer']['receive_method'] ?? 'USDT'));
$promo   = trim($_POST['promo_code'] ?? ($_SESSION['draft_transfer']['promo_code'] ?? ''));


$feeAmt   = (float)($_POST['fee_amount'] ?? ($_SESSION['draft_transfer']['fee_amount'] ?? 0));
$totalAmt = (float)($_POST['total_amount'] ?? ($_SESSION['draft_transfer']['total_amount'] ?? 0));
// whitelist
$allowedSend   = ['USDT','EUR','GBP','USD','ZAR'];
$allowedRecv   = ['USD'];
$allowedMethod = ['USDT','EcoCash','InnBucks'];

if (!in_array($sendCur, $allowedSend, true)) $sendCur = 'USDT';
if (!in_array($recvCur, $allowedRecv, true)) $recvCur = 'USD';
if (!in_array($method,  $allowedMethod, true)) $method  = 'USDT';

// Persist the step-1 data even if user refreshes.
$_SESSION['draft_transfer'] = [
  'send_currency' => $sendCur,
  'send_amount' => $sendAmt,
  'receive_currency' => $recvCur,
  'receive_amount' => $recvAmt,
  'receive_method' => $method,
  'promo_code' => $promo,
      'fee_amount' => $feeAmt,
      'total_amount' => $totalAmt,  'fee_amount' => $feeAmt,
  'total_amount' => $totalAmt,
];

$errors = [];

// Prefill values (POST > existing session receiver)
$receiverSession = $_SESSION['draft_receiver'] ?? [];
$vals = [
  'receiver_name'  => trim($_POST['receiver_name'] ?? ($receiverSession['receiver_name'] ?? '')),
  'receiver_phone' => trim($_POST['receiver_phone'] ?? ($receiverSession['receiver_phone'] ?? '')),
  'receiver_city'  => trim($_POST['receiver_city'] ?? ($receiverSession['receiver_city'] ?? '')),
  'receiver_note'  => trim($_POST['receiver_note'] ?? ($receiverSession['receiver_note'] ?? '')),
  'usdt_address'   => trim($_POST['usdt_address'] ?? ($receiverSession['usdt_address'] ?? '')),
  'ecocash_phone'  => trim($_POST['ecocash_phone'] ?? ($receiverSession['ecocash_phone'] ?? '')),
  'innbucks_phone' => trim($_POST['innbucks_phone'] ?? ($receiverSession['innbucks_phone'] ?? '')),
  'reason'         => trim($_POST['reason'] ?? ($receiverSession['reason'] ?? 'Family or friend support')),
];

if (isset($_POST['submit_details'])) {
  if ($vals['receiver_name'] === '') $errors[] = "Receiver name is required.";
  if ($vals['receiver_city'] === '') $errors[] = "City/Town is required.";
  if ($vals['reason'] === '') $errors[] = "Reason for sending is required.";

  if ($method === 'USDT' && $vals['usdt_address'] === '') $errors[] = "USDT wallet address is required.";
  if ($method === 'EcoCash' && $vals['ecocash_phone'] === '') $errors[] = "EcoCash phone number is required.";
  if ($method === 'InnBucks' && $vals['innbucks_phone'] === '') $errors[] = "InnBucks phone number is required.";

  if ($vals['receiver_phone'] && strlen(preg_replace('/\D+/', '', $vals['receiver_phone'])) < 7) {
    $errors[] = "Receiver phone looks too short.";
  }

  // Save receiver draft for back/refresh
  $_SESSION['draft_receiver'] = $vals;

  if (!$errors) {
    // Save receiver to DB
$phone = trim((string)$vals['receiver_phone']);
if ($phone !== '' && strpos($phone, '+263') !== 0 && preg_match('/^\d{9}$/', preg_replace('/\D+/', '', $phone))) {
  $phone = '+263' . preg_replace('/\D+/', '', $phone);
}
$methodSave = $method;
db_exec("INSERT INTO receivers (user_id, full_name, phone, city, method, created_at, updated_at) VALUES (?,?,?,?,?,NOW(),NOW())",
  [(int)$u['id'], $vals['receiver_name'], $phone, $vals['receiver_city'], $methodSave])->close();
$ridRow = db_row("SELECT LAST_INSERT_ID() AS id");
$receiver_id = $ridRow ? (int)$ridRow['id'] : 0;
$_SESSION['transfer']['receiver_id'] = $receiver_id;
// Final transfer object for review/pay steps

    $_SESSION['transfer'] = [
      'send_currency' => $sendCur,
      'send_amount' => $sendAmt,
      'receive_currency' => $recvCur,
      'receive_amount' => $recvAmt,
      'receive_method' => $method,
      'promo_code' => $promo,
      'eta' => 'Within 5 minutes',
      'receiver' => [
        'name' => $vals['receiver_name'],
        'phone' => $vals['receiver_phone'],
        'city' => $vals['receiver_city'],
        'reason' => $vals['reason'],
        'note' => $vals['receiver_note'],
        'usdt_address' => $vals['usdt_address'],
        'ecocash_phone' => $vals['ecocash_phone'],
        'innbucks_phone' => $vals['innbucks_phone'],
      ],
    ];
    header("Location: review.php");
    exit;
  }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<meta name="theme-color" content="#ffffff"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title>Recipient details</title>

<style>

  /* Prevent sideways shake / horizontal scroll */
  html, body { width:100%; overflow-x:hidden; }
  *, *::before, *::after { box-sizing:border-box; }
  img, svg, video, canvas { max-width:100%; height:auto; }

  /* Premium dark blocks for Send / Receive / Method only */
  .heroWrap{max-width:720px;margin:0 auto;}
  .topRow{display:flex;align-items:center;justify-content:space-between;gap:12px;padding:10px 6px 0;}
  .backBtn{display:inline-flex;align-items:center;justify-content:center;width:44px;height:44px;border-radius:14px;border:1px solid rgba(15,23,42,.08);background:#fff;box-shadow:0 10px 24px rgba(2,6,23,.06);}
  .pageTitle{margin:8px 6px 6px;font-size:34px;line-height:1.1;font-weight:950;letter-spacing:-.6px;}
  .subTitle{margin:0 6px 14px;color:var(--muted);font-weight:900}

  .darkCard{
    border-radius:20px;
    padding:14px;
    background:radial-gradient(120% 120% at 10% 10%, rgba(124,58,237,.35) 0%, rgba(124,58,237,.00) 55%),
               linear-gradient(135deg,#2b0a4a,#14072a);
    color:#fff;
    border:1px solid rgba(255,255,255,.10);
    box-shadow:0 30px 70px rgba(2,6,23,.25);
    margin:10px 6px;
  }
  .darkGrid{display:grid;gap:10px;}
  @media (min-width:720px){ .darkGrid{grid-template-columns:1fr 1fr;} }

  .miniBlock{
    border-radius:16px;
    padding:12px 12px;
    background:rgba(255,255,255,.06);
    border:1px solid rgba(255,255,255,.10);
    display:flex;align-items:center;justify-content:space-between;gap:12px;
  }
  .miniLeft{display:flex;align-items:center;gap:10px;min-width:0;}
  .flag{width:30px;height:30px;border-radius:999px;overflow:hidden;border:2px solid rgba(255,255,255,.18);background:rgba(255,255,255,.08);flex:0 0 auto;}
  .flag img{width:100%;height:100%;object-fit:cover;display:block}
  .k{font-weight:900;opacity:.82;font-size:13px}
  .v{font-weight:950;font-size:18px;white-space:nowrap}
  .amt{font-weight:950;font-size:20px;white-space:nowrap}
  .chips{display:flex;flex-wrap:wrap;gap:8px;margin-top:10px}
  .chip{
    display:inline-flex;align-items:center;gap:8px;
    background:rgba(255,255,255,.08);
    border:1px solid rgba(255,255,255,.12);
    border-radius:999px;
    padding:8px 10px;
    font-weight:900;
  }
  .chip img{width:18px;height:18px;border-radius:999px;object-fit:cover}

  /* Form */
  .card{margin:12px 6px}
  .grid{display:grid;gap:12px}
  @media (min-width:720px){ .grid{grid-template-columns:1fr 1fr;} }
  .field .label{font-weight:950}
  .field input, .field textarea{
    width:100%;
    border-radius:14px;
    border:1px solid rgba(15,23,42,.10);
    padding:14px 14px;
    font-weight:900;
    background:#fff;
  }
  .small{color:var(--muted);font-weight:900;font-size:13px;margin-top:8px}

  /* +263 phone input group */
  .phoneWrap{
    position:relative;
    display:flex;align-items:center;
    border:1px solid rgba(15,23,42,.10);
    border-radius:14px;
    overflow:hidden;
    background:#fff;
  }
  .phonePrefix{
    padding:0 12px;
    font-weight:950;
    color:#0f172a;
    background:rgba(124,58,237,.05);
    border-right:1px solid rgba(15,23,42,.08);
    height:52px;
    display:flex;align-items:center;
  }
  .phoneWrap input{
    border:none !important;
    border-radius:0 !important;
    padding:14px 14px !important;
    height:52px;
  }

  /* Reason picker (premium sheet) */
  .reasonBtn{
    display:flex;
    align-items:center;
    justify-content:space-between;
    gap:12px;
    width:100%;
    border-radius:16px;
    padding:14px 14px;
    font-weight:950;
    cursor:pointer;
    color:#fff;
    border:1px solid rgba(255,255,255,.12);
    background:radial-gradient(120% 120% at 10% 10%, rgba(124,58,237,.35) 0%, rgba(124,58,237,.00) 55%),
               linear-gradient(135deg,#2b0a4a,#14072a);
    box-shadow:0 24px 55px rgba(2,6,23,.20);
  }
  .reasonBtn .hint{color:rgba(255,255,255,.78);font-weight:900;font-size:13px}
  .reasonBtn svg{color:rgba(255,255,255,.85)}

  .overlay{position:fixed;inset:0;z-index:9999;display:none}
  .overlay.show{display:block}
  .overlayBg{position:absolute;inset:0;background:rgba(15,23,42,.35)}
  .sheet{
    position:absolute;left:50%;transform:translateX(-50%);
    bottom:12px;width:min(640px,calc(100vw - 18px));
    background:#fff;border-radius:22px;
    box-shadow:0 30px 70px rgba(2,6,23,.22);
    border:1px solid rgba(15,23,42,.10);
    overflow:hidden;
  }
  .sheetTop{
    padding:14px 16px;
    display:flex;align-items:center;justify-content:space-between;gap:10px;
    border-bottom:1px solid rgba(15,23,42,.08);
    background:rgba(124,58,237,.04);
  }
  .sheetTop .t{font-weight:950;font-size:20px}
  .sheetClose{
    width:44px;height:44px;border-radius:999px;border:none;
    background:rgba(15,23,42,.06);cursor:pointer;
    display:grid;place-items:center;
  }
  .sheetList{padding:10px}
  .sheetItem{
    width:100%;
    border:none;
    background:#fff;
    padding:16px 14px;
    border-radius:16px;
    font-weight:950;
    font-size:18px;
    text-align:left;
    cursor:pointer;
    border:1px solid rgba(15,23,42,.08);
    margin-bottom:10px;
  }
  .sheetItem:hover{background:rgba(124,58,237,.06)}
  .sheetItem:active{transform:scale(.996)}

  /* Errors */
  .alert{
    margin:10px 6px;
    border-radius:16px;
    padding:12px 12px;
    border:1px solid rgba(239,68,68,.20);
    background:rgba(239,68,68,.08);
    color:#7f1d1d;
    font-weight:900;
  }
  .alert ul{margin:8px 0 0 18px}

  /* Primary button */
  .primaryBtn{width:calc(100% - 12px);margin:12px 6px 26px}

  .shell, .content, .wrap, .container, .page, .card, .darkCard { max-width:100%; }

</style>
</head>

<body>
<div class="app"><div class="shell"><div class="content heroWrap">

  <div class="topRow">
    <a class="backBtn" href="send.php" aria-label="Back">
      <svg viewBox="0 0 24 24" width="22" height="22" fill="none" aria-hidden="true">
        <path d="M15 18l-6-6 6-6" stroke="currentColor" stroke-width="2.2" stroke-linecap="round" stroke-linejoin="round"/>
      </svg>
    </a>
    <div style="width:44px;height:44px"></div>
  </div>

  <div class="pageTitle">Recipient details</div>
  <div class="subTitle">Confirm the amounts, then enter receiver info.</div>

  <?php if ($errors): ?>
    <div class="alert">
      Please fix the following:
      <ul>
        <?php foreach ($errors as $e): ?><li><?= h($e) ?></li><?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <?php
    // Logo mapping (same assets you used across steps)
    $logos = [
      'USDT' => 'https://i.imgur.com/rDkAovM.png',
      'USD'  => 'https://i.imgur.com/X1kw5aO.png',
      'EUR'  => 'https://i.imgur.com/Dc00hbM.png',
      'GBP'  => 'https://i.imgur.com/RcORDlF.png',
      'ZIM'  => 'https://i.imgur.com/WMdMxPI.png',
      'EcoCash'  => 'https://i.imgur.com/mEy6liY.png',
      'InnBucks' => 'https://i.imgur.com/Xd2DK8s.png',
    ];
    $sendLogo = $logos[$sendCur] ?? $logos['USD'];
    $recvLogo = $logos['ZIM'];
    $methodLogo = $logos[$method] ?? ($methodLogo ?? $logos['EcoCash']);
  ?>

  <!-- Premium dark blocks: Send / Receive / Method -->
  <div class="darkCard">
    <div class="darkGrid">
      <div class="miniBlock">
        <div class="miniLeft">
          <div class="flag"><img src="<?= h($sendLogo) ?>" alt="<?= h($sendCur) ?>" onerror="this.style.display='none'"></div>
          <div>
            <div class="k">You send</div>
            <div class="v"><?= h($sendCur) ?></div>
          </div>
        </div>
        <div class="amt"><?= h(number_format((float)$sendAmt, 2)) ?></div>
      </div>

      <div class="miniBlock">
        <div class="miniLeft">
          <div class="flag"><img src="<?= h($recvLogo) ?>" alt="<?= h($recvCur) ?>" onerror="this.style.display='none'"></div>
          <div>
            <div class="k">They receive</div>
            <div class="v"><?= h($recvCur) ?></div>
          </div>
        </div>
        <div class="amt"><?= h(number_format((float)$recvAmt, 2)) ?></div>
      </div>
    </div>

    <div class="chips">
      <div class="chip">
        <img src="<?= h($methodLogo) ?>" alt="<?= h($method) ?>" onerror="this.style.display='none'">
        <span>Method:</span> <strong><?= h($method) ?></strong>
      </div>
      <div class="chip"><span>Fee:</span> <strong><?= h(number_format((float)$feeAmt, 2)) ?> <?= h($sendCur) ?></strong></div>
      <div class="chip"><span>Total:</span> <strong><?= h(number_format((float)$totalAmt, 2)) ?> <?= h($sendCur) ?></strong></div>
    </div>

    <div class="small" style="margin-top:10px;color:rgba(255,255,255,.78)">Receiver currency is USD by default in this prototype.</div>
  </div>

  <form method="POST" autocomplete="on">
    <input type="hidden" name="send_currency" value="<?= h($sendCur) ?>">
    <input type="hidden" name="send_amount" value="<?= h($sendAmt) ?>">
    <input type="hidden" name="receive_currency" value="<?= h($recvCur) ?>">
    <input type="hidden" name="receive_amount" value="<?= h($recvAmt) ?>">
    <input type="hidden" name="receive_method" value="<?= h($method) ?>">
    <input type="hidden" name="promo_code" value="<?= h($promo) ?>">

    <div class="card">
      <div class="grid">
        <div class="field">
          <div class="label">Receiver full name</div>
          <input
            name="receiver_name"
            value="<?= h($vals['receiver_name']) ?>"
            placeholder="e.g., Tawanda Moyo"
            required
            minlength="2"
            maxlength="40"
            autocomplete="name">
          <div class="small">Max 40 characters.</div>
        </div>

        <div class="field">
          <div class="label">City / Town</div>
          <input
            name="receiver_city"
            value="<?= h($vals['receiver_city']) ?>"
            placeholder="e.g., Harare"
            required
            minlength="2"
            maxlength="40"
            autocomplete="address-level2">
          <div class="small">Max 40 characters.</div>
        </div>

        <div class="field">
          <div class="label">Receiver phone (optional)</div>
          <div class="phoneWrap">
            <div class="phonePrefix">+263</div>
            <input
              name="receiver_phone"
              id="receiverPhone"
              value="<?= h(preg_replace('/^\+263\s*/', '', $vals['receiver_phone'])) ?>"
              placeholder="77XXXXXXX"
              inputmode="numeric"
              autocomplete="tel"
              maxlength="9"
              pattern="\d{9}">
          </div>
          <div class="small">Enter 9 digits (e.g., 771234567). We’ll store it as +263XXXXXXXXX.</div>
        </div>

        <?php if ($method === 'USDT'): ?>
          <div class="field">
            <div class="label">USDT wallet address</div>
            <input
              name="usdt_address"
              value="<?= h($vals['usdt_address']) ?>"
              placeholder="TRC20 / ERC20 address"
              required
              minlength="10"
              autocomplete="off">
            <div class="small">We’ll add network selection (TRC20 / ERC20) next.</div>
          </div>
        <?php elseif ($method === 'EcoCash'): ?>
          <div class="field">
            <div class="label">EcoCash number</div>
            <div class="phoneWrap">
              <div class="phonePrefix">+263</div>
              <input
                name="ecocash_phone"
                id="ecocashPhone"
                value="<?= h(preg_replace('/^\+263\s*/', '', $vals['ecocash_phone'])) ?>"
                placeholder="77XXXXXXX"
                inputmode="numeric"
                maxlength="9"
                pattern="\d{9}"
                required>
            </div>
            <div class="small">Enter 9 digits. We’ll store it as +263XXXXXXXXX.</div>
          </div>
        <?php elseif ($method === 'InnBucks'): ?>
          <div class="field">
            <div class="label">InnBucks number</div>
            <div class="phoneWrap">
              <div class="phonePrefix">+263</div>
              <input
                name="innbucks_phone"
                id="innbucksPhone"
                value="<?= h(preg_replace('/^\+263\s*/', '', $vals['innbucks_phone'])) ?>"
                placeholder="77XXXXXXX"
                inputmode="numeric"
                maxlength="9"
                pattern="\d{9}"
                required>
            </div>
            <div class="small">Enter 9 digits. We’ll store it as +263XXXXXXXXX.</div>
          </div>
        <?php endif; ?>

        <!-- Reason for funding (replaces notes) -->
        <div class="field" style="grid-column:1/-1;">
          <div class="label">Reason for funding</div>

          <input type="hidden" name="reason" id="reasonValue" value="<?= h($vals['reason']) ?>">
          <button type="button" class="reasonBtn" id="reasonOpen">
            <div style="display:flex;flex-direction:column;align-items:flex-start;gap:2px;min-width:0">
              <div class="hint">Reason for funding</div>
              <div id="reasonText" style="font-weight:950;font-size:18px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;max-width:100%;"><?= h($vals['reason']) ?></div>
            </div>
            <svg viewBox="0 0 24 24" width="18" height="18" fill="none" aria-hidden="true" style="opacity:.7">
              <path d="M7 10l5 5 5-5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
          </button>
          <div class="small">Required. Helps compliance and fraud protection.</div>
        </div>

      </div>
    </div>

    <button class="primaryBtn" type="submit" name="submit_details" value="1">Continue</button>
  </form>

</div></div></div>

<!-- Reason bottom sheet -->
<div class="overlay" id="reasonSheet">
  <div class="overlayBg" id="reasonBg"></div>
  <div class="sheet" role="dialog" aria-modal="true" aria-label="Reason for funding">
    <div class="sheetTop">
      <div class="t">Reason for Funding</div>
      <button class="sheetClose" id="reasonClose" type="button" aria-label="Close">
        <svg viewBox="0 0 24 24" width="20" height="20" fill="none" aria-hidden="true">
          <path d="M18 6L6 18M6 6l12 12" stroke="currentColor" stroke-width="2.2" stroke-linecap="round"/>
        </svg>
      </button>
    </div>
    <div class="sheetList">
      <button class="sheetItem" type="button" data-reason="Family or friend support">Family or friend support</button>
      <button class="sheetItem" type="button" data-reason="Property payment">Property payment</button>
      <button class="sheetItem" type="button" data-reason="Sending funds to self">Sending funds to self</button>
      <button class="sheetItem" type="button" data-reason="Purchase of services">Purchase of services</button>
    </div>
  </div>
</div>

<script src="../assets/app.js"></script>
<script>
  // Prepend +263 on submit (server expects full number in the same field)
  function withPrefix(id){
    const el = document.getElementById(id);
    if(!el) return null;
    const digits = (el.value || "").replace(/\D+/g,'').slice(0,9);
    el.value = digits;
    return "+263" + digits;
  }

  // Before submit, convert the visible 9-digit fields into +263XXXXXXXXX by replacing their value
  document.querySelector('form')?.addEventListener('submit', function(){
    const rp = document.getElementById('receiverPhone');
    if(rp){
      const full = "+263" + (rp.value || "").replace(/\D+/g,'').slice(0,9);
      rp.value = full;
    }
    const ep = document.getElementById('ecocashPhone');
    if(ep){
      const full = "+263" + (ep.value || "").replace(/\D+/g,'').slice(0,9);
      ep.value = full;
    }
    const ip = document.getElementById('innbucksPhone');
    if(ip){
      const full = "+263" + (ip.value || "").replace(/\D+/g,'').slice(0,9);
      ip.value = full;
    }
  });

  // Reason sheet
  const sheet = document.getElementById('reasonSheet');
  const openBtn = document.getElementById('reasonOpen');
  const closeBtn = document.getElementById('reasonClose');
  const bg = document.getElementById('reasonBg');
  const reasonValue = document.getElementById('reasonValue');
  const reasonText = document.getElementById('reasonText');

  function openSheet(){ sheet.classList.add('show'); if(window.SendZim?.haptic) SendZim.haptic(); }
  function closeSheet(){ sheet.classList.remove('show'); }

  openBtn?.addEventListener('click', openSheet);
  closeBtn?.addEventListener('click', closeSheet);
  bg?.addEventListener('click', closeSheet);
  document.addEventListener('keydown', (e)=>{ if(e.key==='Escape') closeSheet(); });

  document.querySelectorAll('.sheetItem').forEach(btn=>{
    btn.addEventListener('click', ()=>{
      const r = btn.getAttribute('data-reason') || '';
      reasonValue.value = r;
      reasonText.textContent = r;
      closeSheet();
      if(window.SendZim?.toast) SendZim.toast("Reason selected");
      if(window.SendZim?.haptic) SendZim.haptic();
    });
  });
</script>
</body>
</html>
