<?php
declare(strict_types=1);
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
require_once __DIR__ . '/../backend/models/transfers.php';
require_once __DIR__ . '/../backend/models/rates.php';
require_once __DIR__ . '/../backend/lib/payments_trc20.php';
require_once __DIR__ . '/../backend/models/notifications.php';
$u = require_login();
csrf_token();

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$wallet_address = "TKa4giaSB5SYHGi3zp7KTzFRiMwN3YATD7";
$qr_url = "https://i.imgur.com/vOjXMST.jpeg";

$transfer_id = isset($_GET['transfer_id']) ? (int)$_GET['transfer_id'] : (int)($_SESSION['transfer_id'] ?? 0);
if ($transfer_id <= 0) { header("Location: send.php"); exit; }

$tr = db_row("SELECT t.*, r.full_name AS receiver_name, r.phone AS receiver_phone
              FROM transfers t
              LEFT JOIN receivers r ON r.id=t.receiver_id
              WHERE t.id=? AND t.user_id=?", [$transfer_id, (int)$u['id']]);
if (!$tr) { http_response_code(404); die("Transfer not found."); }


// Compute expected payable in USDT (≈ USD) from send_currency.
// We use live FX pairs to USD when available (EURUSD, GBPUSD). USD/USDT are 1:1.
$send_cur = strtoupper((string)($tr['send_currency'] ?? 'USD'));
$send_amount = (float)($tr['send_amount'] ?? 0);
$fee_amount = (float)($tr['fee_amount'] ?? 0);
$total_send = max(0.0, $send_amount); // user pays the full send amount; fee is already included in this total in our flow.

$to_usd = 1.0;
if ($send_cur === 'EUR') $to_usd = fx_rate('EURUSD', 1.08);
elseif ($send_cur === 'GBP') $to_usd = fx_rate('GBPUSD', 1.27);
elseif ($send_cur === 'USD') $to_usd = 1.0;
elseif ($send_cur === 'USDT') $to_usd = 1.0;

$expected_usdt = round($total_send * $to_usd, 2);

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $txid = trim((string)($_POST['txid'] ?? ''));
  if ($txid === '' || strlen($txid) < 20 || strlen($txid) > 120) {
    $err = "Please enter a valid Binance/Tron transaction ID (TxID).";
  } else {
    // Save TXID immediately
    db_exec("UPDATE transfers SET payment_txid=?, status='payment_submitted', updated_at=NOW() WHERE id=? AND user_id=?",
      [$txid, $transfer_id, (int)$u['id']])->close();

    // Try to auto-verify TRC20 USDT payment
    $v = verify_usdt_trc20_txid($txid, $wallet_address, $expected_usdt);
    if ($v['ok']) {
      // Mark as paid and ready for payout processing
      db_exec("UPDATE transfers SET status='paid_verified', updated_at=NOW() WHERE id=? AND user_id=?",
        [$transfer_id, (int)$u['id']])->close();
      notify_after_payment_verified($transfer_id);

      $_SESSION['toast'] = "Payment verified ✅";
    } else {
      // Keep as submitted; admin or background checker can verify later.
      // Store a helpful message for the user.
      $_SESSION['toast'] = $v['message'] ?: "TXID saved. We'll verify shortly.";
    }

    header("Location: ../transfers/index.php");
    exit;
  }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title>Pay (USDT)</title>
<style>
  .card2{background:#fff;border:1px solid rgba(15,23,42,.10);border-radius:20px;padding:14px}
  .grid2{display:grid;gap:12px}
  .qr{width:190px;max-width:70vw;border-radius:18px;border:1px solid rgba(15,23,42,.12);box-shadow:0 16px 36px rgba(15,23,42,.10)}
  .addr{font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;font-weight:900;font-size:12.5px;word-break:break-all;background:rgba(124,58,237,.06);border:1px solid rgba(124,58,237,.14);padding:10px 12px;border-radius:16px}
  .input{font-size:16px;padding:12px 12px;border-radius:14px;border:1px solid rgba(15,23,42,.12);width:100%}
  .input:focus{border-color:rgba(124,58,237,.55);box-shadow:0 0 0 4px rgba(124,58,237,.12)}
  .err{border:1px solid rgba(239,68,68,.18);background:rgba(239,68,68,.06);padding:10px 12px;border-radius:16px;font-weight:900;color:rgba(153,27,27,.92)}
</style>
</head>
<body>
<div class="app"><div class="shell">
  <div class="topbar">
    <div class="brand"><div class="sub">Payment (USDT)</div></div>
    <div class="icons">
      <a class="iconbtn" href="review.php" aria-label="Back" title="Back">
        <svg viewBox="0 0 24 24" fill="none"><path d="M15 18l-6-6 6-6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
      </a>
    </div>
  </div>

  <div class="content">
    <div class="grid2">
      <div class="card2">
        <div class="h2">Send USDT to our Binance wallet</div>
        <div class="muted" style="font-weight:850">Then paste your TXID / reference below to submit payment.</div>

        <div style="display:grid;place-items:center;margin-top:12px">
          <img class="qr" src="<?= h($qr_url) ?>" alt="Binance QR Code">
        </div>

        <div style="margin-top:12px;font-weight:950">Wallet address</div>
        <div class="addr" id="addr"><?= h($wallet_address) ?></div>

        <button class="miniBtn" type="button" id="copyBtn" style="width:100%;margin-top:10px">Copy address</button>
      </div>

      <div class="card2">
        <div class="h2">Transfer summary</div>
        <div class="meta">To: <b><?= h($tr['receiver_name'] ?? 'Receiver') ?></b> (<?= h($tr['receiver_phone'] ?? '') ?>)</div>
        <div class="meta">Receive via: <b><?= h($tr['receive_method']) ?></b></div>
        <div class="meta">You send: <b><?= h($tr['send_amount']) ?> <?= h($tr['send_currency']) ?></b> • Fee: <?= h($tr['fee_amount']) ?> <?= h($tr['send_currency']) ?></div>
        <div class="meta">They receive: <b><?= h($tr['receive_amount']) ?> <?= h($tr['receive_currency']) ?></b></div>
      </div>

      <div class="card2">
        <div class="h2">Submit payment</div>
        <?php if($err): ?><div class="err"><?= h($err) ?></div><div style="height:10px"></div><?php endif; ?>
        <form method="post">
          <?= csrf_field() ?>
          <div class="muted" style="font-weight:850;margin-bottom:8px">Paste Binance TXID / reference</div>
          <input class="input" name="txid" placeholder="e.g. 9a7c... / Binance reference" maxlength="120" required>
          <button class="primaryBtn" style="width:100%;margin-top:12px">Submit &amp; finish</button>
          <div class="muted" style="font-weight:850;margin-top:10px">After submission, your transfer status becomes <b>payment submitted</b> and will be verified.</div>
        </form>
      </div>
    </div>
  </div>

  <?php include __DIR__ . '/../partials/bottom_nav.php'; ?>
</div></div>

<script src="../assets/app.js"></script>
<script>
SendZim.setActiveNav("send"); SendZim.setUserUI();
document.getElementById("copyBtn")?.addEventListener("click", ()=>{
  const txt = document.getElementById("addr")?.textContent || "";
  navigator.clipboard?.writeText(txt);
  SendZim.toast("Copied ✅");
  SendZim.haptic();
});
</script>
</body>
</html>