<?php
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
csrf_token();
$u = require_login();
require_once __DIR__ . '/../backend/models/transfers.php';
// review.php — SendZim Step 3: Review transfer (professional confirmation)
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function num2($n){ return number_format((float)$n, 2, '.', ''); }

$transfer = $_SESSION['transfer'] ?? null;
if (!$transfer) { header("Location: send.php"); exit; }


// On confirm: create transfer in DB then go to payment
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm'])) {
  csrf_check();
  $qid = (string)($transfer['quote_id'] ?? '');
  $rid = (int)($transfer['receiver_id'] ?? 0);
  $method = (string)($transfer['receive_method'] ?? 'USDT');
  $reason = (string)($transfer['reason'] ?? 'Family support');
  $notify_receiver = isset($_POST['notify_receiver']) ? (int)$_POST['notify_receiver'] : 0;
  $_SESSION['transfer']['notify_receiver'] = $notify_receiver ? 1 : 0;
  if ($qid && $rid) {
    $tid = create_transfer_from_quote($qid, $rid, $method, $reason, (int)($_SESSION['transfer']['notify_receiver'] ?? 0), 0);
    $_SESSION['transfer_id'] = $tid;
    header("Location: pay.php?transfer_id=".$tid);
    exit;
  }
}
$sendCur = $transfer['send_currency'] ?? 'USDT';
$sendAmt = (float)($transfer['send_amount'] ?? 0);
$recvCur = $transfer['receive_currency'] ?? 'USD';
$recvAmt = (float)($transfer['receive_amount'] ?? 0);
$method  = $transfer['receive_method'] ?? 'USDT';
$feeStored = isset($transfer['fee_amount']) ? (float)$transfer['fee_amount'] : 0;
$totalStored = isset($transfer['total_amount']) ? (float)$transfer['total_amount'] : 0;

$eta     = $transfer['eta'] ?? 'Within 5 minutes';

$methodLogo = [
  'USDT' => 'https://i.imgur.com/rDkAovM.png',
  'EcoCash' => 'https://i.imgur.com/mEy6liY.png',
  'InnBucks' => 'https://i.imgur.com/Xd2DK8s.png',
][$method] ?? '';

$fee = $feeStored > 0 ? $feeStored : 2.99; // use stored fee from previous step

// Ensure review uses the SAME fee/total chosen earlier (send/receive step)
if (!isset($_SESSION['transfer'])) $_SESSION['transfer'] = [];
$_SESSION['transfer']['fee_amount'] = $fee;
if ($totalStored > 0) {
  $_SESSION['transfer']['total_amount'] = $totalStored;
} else {
  $_SESSION['transfer']['total_amount'] = $sendAmt + $fee;
}
// Exchange rate line (best-effort, derived from amounts)
$rateLine = "—";
if ($sendAmt > 0 && $recvAmt > 0) {
  $x = $recvAmt / $sendAmt;
  $rateLine = "1 " . $sendCur . " = " . number_format($x, 4, '.', '') . " USD";
}
$totalAmount = $totalStored > 0 ? $totalStored : ($sendAmt + $fee);

$receiver = $transfer['receiver'] ?? [];
$receiverName = $receiver['name'] ?? 'Recipient';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
  <meta name="theme-color" content="#ffffff"/>
  <title>SendZim — Review transfer</title>
  <style>
    :root{--bg:#fff;--text:#0b0f1a;--muted:#6b7280;--stroke:#e6e8ee;--soft:#f4f5f7;--brand:#7c3aed;--shadow:0 10px 28px rgba(16,24,40,.08);--maxw:560px;--safeBottom:env(safe-area-inset-bottom,0px);--safeTop:env(safe-area-inset-top,0px)}
    *{box-sizing:border-box}
    body{margin:0;font-family:ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial;background:var(--bg);color:var(--text);-webkit-font-smoothing:antialiased}
    a{color:inherit;text-decoration:none}
    .wrap{min-height:100vh;display:flex;justify-content:center;padding:0 14px}
    .shell{width:min(var(--maxw),100%);min-height:100vh;padding:calc(10px + var(--safeTop)) 0 calc(24px + var(--safeBottom))}
    .top{display:flex;align-items:center;gap:12px;padding:10px 2px 14px}
    .back{width:40px;height:40px;border-radius:14px;border:1px solid transparent;background:transparent;display:grid;place-items:center;cursor:pointer}
    .back:hover{background:rgba(124,58,237,.06)}
    .back svg{width:22px;height:22px;color:var(--brand)}
    h1{margin:0;font-size:28px;font-weight:950;letter-spacing:-.2px}

    .hero{
      background:linear-gradient(135deg, rgba(124,58,237,1), rgba(91,33,182,1));
      border-radius:22px;color:#fff;padding:16px;position:relative;overflow:hidden;
      box-shadow:0 18px 40px rgba(124,58,237,.22);margin:6px 0 12px
    }
    .hero:after{content:"";position:absolute;inset:-60px -100px auto auto;width:260px;height:260px;background:rgba(255,255,255,.10);border-radius:999px;transform:rotate(20deg)}
    .heroTitle{font-weight:950;font-size:18px;opacity:.95}
    .heroAmt{font-weight:950;font-size:38px;letter-spacing:-.5px;margin-top:8px}
    .heroRow{display:flex;align-items:center;gap:10px;margin-top:10px;font-weight:900;opacity:.98}
    .heroIcons{position:absolute;right:14px;bottom:14px;display:flex;gap:10px;align-items:center}
    .pillIcon{width:44px;height:44px;border-radius:999px;background:#fff;display:grid;place-items:center;overflow:hidden;border:1px solid rgba(255,255,255,.25)}
    .pillIcon img{width:100%;height:100%;object-fit:cover;display:block}

    .sectionHead{display:flex;align-items:center;justify-content:space-between;margin:14px 2px 8px}
    .sectionHead .t{font-weight:950;color:var(--muted);letter-spacing:.14em;font-size:12px;}
    .editBtn{display:inline-flex;align-items:center;justify-content:center;gap:8px;padding:8px 12px;border-radius:12px;border:1px solid rgba(124,58,237,.22);background:rgba(124,58,237,.10);color:var(--brand);font-weight:950;text-decoration:none;}
    .editBtn:active{transform:scale(.98)}

    .card{background:#fff;border:1px solid var(--stroke);border-radius:20px;box-shadow:var(--shadow);padding:14px;margin:10px 0}
    .rows{display:grid;gap:10px}
    .rowItem{display:flex;align-items:flex-start;justify-content:space-between;gap:12px}
    .rowItem .k{color:var(--muted);font-weight:900}
    .rowItem .v{font-weight:950;text-align:right}
    .divider{height:1px;background:rgba(230,232,238,.9);margin:12px 0}
    .small{color:var(--muted);font-size:12.5px;font-weight:900;line-height:1.45}
    .warn{color:var(--muted);font-weight:900;font-size:12.5px;line-height:1.45;margin-top:10px}
    .btn{width:100%;border:0;padding:16px 14px;border-radius:18px;background:var(--brand);color:#fff;font-weight:950;font-size:16px;cursor:pointer;box-shadow:0 16px 30px rgba(124,58,237,.24)}
  
    /* --- Typography normalize (uniform, fintech-grade) --- */
    html,body{font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji","Segoe UI Emoji"; }
    body{color:#0f172a; font-weight:600; letter-spacing:-0.1px;}
    .subtle{font-weight:800; color:var(--muted); letter-spacing:.08em; font-size:12px;}
    .rowItem .k{font-size:13px; font-weight:850; color:var(--muted);}
    .rowItem .v{font-size:15px; font-weight:950; color:#0f172a;}
    .note{font-size:13px; font-weight:700; color:#475569; line-height:1.35;}
    
</style>
</head>
<body>
<div class="wrap"><div class="shell">
  <div class="top">
    <button class="back" onclick="history.back()" aria-label="Back">
      <svg viewBox="0 0 24 24" fill="none"><path d="M15 18l-6-6 6-6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
    </button>
    <div><h1>Review transfer</h1></div>
  </div>

  <div class="hero">
    <div class="heroTitle"><?= h($receiverName) ?> will receive</div>
    <div class="heroAmt"><?= h(num2($recvAmt)) ?> <?= h($recvCur) ?></div>
    <div class="heroRow">⚡ <b><?= h($eta) ?></b></div>

    <div class="heroIcons">
      <div class="pillIcon" title="Zimbabwe"><img alt="Zimbabwe" src="https://i.imgur.com/WMdMxPI.png" onerror="this.style.display='none'"></div>
      <?php if ($methodLogo): ?>
        <div class="pillIcon" title="<?= h($method) ?>"><img alt="<?= h($method) ?>" src="<?= h($methodLogo) ?>" onerror="this.style.display='none'"></div>
      <?php endif; ?>
    </div>
  </div>

  <div class="sectionHead">
    <div class="t">TRANSFER DETAILS</div>
    <a class="editBtn" href="send.php">Edit</a>
  </div>

  <div class="card">
    <div class="rows">
      <div class="rowItem"><div class="k">Receive method</div><div class="v"><?= h($method) ?></div></div>
      <div class="rowItem"><div class="k">Transfer amount</div><div class="v"><?= h(num2($sendAmt)) ?> <?= h($sendCur) ?></div></div>
      <div class="rowItem"><div class="k">Transfer fees</div><div class="v"><?= h(num2($fee)) ?> <?= h($sendCur) ?></div></div>
      <div class="rowItem"><div class="k">Exchange rate</div><div class="v"><?= h($rateLine) ?></div></div>
      <div class="rowItem"><div class="k">Total to recipient</div><div class="v"><?= h(num2($recvAmt)) ?> <?= h($recvCur) ?></div></div>
      <div class="small">Your recipient may get less due to fees charged by the wallet provider, a bank, and/or foreign taxes.</div>
      <div class="divider"></div>
      <div class="rowItem">
        <div class="k" style="font-weight:950;color:var(--text)">Total amount</div>
        <div class="v" style="color:var(--brand);font-size:22px;letter-spacing:-.2px;"><?= h(num2($totalAmount)) ?> <?= h($sendCur) ?></div>
      </div>
    </div>
  </div>

  <div class="sectionHead">
    <div class="t">RECEIVER’S DETAILS</div>
    <a class="editBtn" href="next.php">Edit</a>
  </div>

  <div class="card">
    <div class="rows">
      <div class="rowItem"><div class="k">Name</div><div class="v"><?= h($receiver['name'] ?? '') ?></div></div>
      <?php if ($method === 'EcoCash'): ?>
        <div class="rowItem"><div class="k">EcoCash Mobile Number</div><div class="v"><?= h($receiver['ecocash_phone'] ?? '') ?></div></div>
      <?php elseif ($method === 'InnBucks'): ?>
        <div class="rowItem"><div class="k">InnBucks Mobile Number</div><div class="v"><?= h($receiver['innbucks_phone'] ?? '') ?></div></div>
      <?php elseif ($method === 'USDT'): ?>
        <div class="rowItem"><div class="k">USDT wallet</div><div class="v"><?= h($receiver['usdt_address'] ?? '') ?></div></div>
      <?php endif; ?>
      <div class="rowItem"><div class="k">City/Town</div><div class="v"><?= h($receiver['receiver_city'] ?? ($receiver['city'] ?? '')) ?></div></div>
      <div class="rowItem"><div class="k">Reason for Sending</div><div class="v"><?= h($receiver['reason'] ?? '') ?></div></div>
    </div>
  </div>

  <div class="warn">
    <div style="font-weight:950;color:var(--text);margin-bottom:4px;">Do you know this person?</div>
    Make sure you're sending money to someone you know and trust, and their information is correct.
    Fraudulent transactions may result in the loss of money with no recourse.
  </div>

  <div class="card white" style="margin:12px 0 10px;">
  <div style="display:flex;align-items:flex-start;gap:12px;">
    <div style="width:44px;height:44px;border-radius:14px;background:rgba(124,58,237,.08);display:grid;place-items:center;flex:0 0 auto;">
      <svg viewBox="0 0 24 24" width="22" height="22" fill="none" aria-hidden="true">
        <path d="M20 12a8 8 0 1 1-16 0" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
        <path d="M8.5 12.5 11 15l5-6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
      </svg>
    </div>
    <div style="flex:1;">
      <div style="font-weight:950;color:var(--text);letter-spacing:-.2px;">WhatsApp updates</div>
      <div class="muted" style="margin-top:2px;font-weight:850;">Send a confirmation to the recipient on WhatsApp after payment is verified.</div>
    </div>
    <label style="display:flex;align-items:center;gap:10px;cursor:pointer;user-select:none;">
      <input type="hidden" name="notify_receiver" value="0">
      <input type="checkbox" name="notify_receiver" value="1" style="width:20px;height:20px;accent-color:var(--brand);"
        <?= ((int)($transfer['notify_receiver'] ?? 0) === 1) ? 'checked' : '' ?>>
    </label>
  </div>
  <div class="muted" style="margin-top:10px;font-weight:850;line-height:1.35;">
    By enabling this, you confirm you have permission to message the recipient about this transfer.
  </div>
</div>
<form method="POST" action="review.php" style="margin-top:14px;">
    <input type="hidden" name="confirm" value="1">
    <button class="btn">Next</button>
  </form>

</div></div>
</body>
</html>
