<?php
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/lib/csrf.php';
csrf_token();
$u = require_login();
// send.php — SendZim "Send money" (Step 1)
// Modular version:
// - Receive method UI: components/receive_method.php
// - Promo code row: components/promo_code.php
// Posts to next.php
session_start();
if (!isset($_SESSION['user_name']) || trim($_SESSION['user_name']) === '') {
  $_SESSION['user_name'] = $u['full_name'] ?? "User";
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
  <meta name="theme-color" content="#ffffff"/>
  <title>SendZim — Send money</title>
  <style>
    :root{
      --bg:#ffffff; --text:#0b0f1a; --muted:#6b7280; --stroke:#e6e8ee;
      --card:#ffffff; --soft:#f4f5f7; --brand:#7c3aed;
      --shadow: 0 10px 28px rgba(16,24,40,.08);
      --radius:20px; --safeBottom: env(safe-area-inset-bottom, 0px);
      --safeTop: env(safe-area-inset-top, 0px); --maxw: 560px;
    }
    *{box-sizing:border-box}
    body{margin:0;font-family:ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial;background:var(--bg);color:var(--text);-webkit-font-smoothing:antialiased}
    .wrap{min-height:100vh;display:flex;justify-content:center;padding:0 14px}
    .shell{width:min(var(--maxw),100%);min-height:100vh;padding:calc(10px + var(--safeTop)) 0 calc(140px + var(--safeBottom))}
    .top{display:flex;align-items:center;gap:12px;padding:10px 2px 14px}
    .back{width:40px;height:40px;border-radius:14px;border:1px solid transparent;background:transparent;display:grid;place-items:center;cursor:pointer}
    .back:hover{background:rgba(124,58,237,.06)}
    .back svg{width:22px;height:22px;color:var(--brand)}
    h1{margin:0;font-size:30px;letter-spacing:-.2px;font-weight:950;line-height:1.05}
    .sub{margin-top:6px;color:var(--muted);font-weight:900;font-size:13px}
    .card{background:var(--card);border:1px solid var(--stroke);border-radius:20px;box-shadow:var(--shadow);padding:14px;margin:10px 0}
    .fieldBox{border:1px solid var(--stroke);border-radius:16px;background:#fff;padding:12px;display:flex;align-items:center;justify-content:space-between;gap:10px}
    .fieldLeft{flex:1;min-width:0}
    .label{font-size:12px;font-weight:900;letter-spacing:.2px;color:var(--muted);margin-bottom:6px}
    .amount{width:100%;border:0;outline:none;background:transparent;font-size:34px;font-weight:950;letter-spacing:-.4px}
    .menu{position:relative}
    .pill{
      display:flex;align-items:center;gap:12px;
      border:0;
      border-radius:18px;
      padding:12px 14px;
      background:linear-gradient(135deg,#2b0a4a,#1f0a33);
      color:#fff;
      cursor:pointer;
      user-select:none;
      flex:0 0 auto;
      min-width:175px;
      justify-content:space-between;
      box-shadow:0 18px 34px rgba(31,10,51,.22);
    }
    .iconWrap{
      width:30px;height:30px;border-radius:999px;
      display:grid;place-items:center;
      background:rgba(255,255,255,.10);
      border:1px solid rgba(255,255,255,.18);
      box-shadow:none;
      overflow:hidden;flex:0 0 auto
    }
    .iconWrap img{width:100%;height:100%;object-fit:cover;display:block}
    .iconWrap svg{width:18px;height:18px;color:var(--brand)}
    .pill b{font-size:14px}
    .chev{width:18px;height:18px;color:var(--muted)}
    .menuPanel{position:absolute;right:0;top:calc(100% + 10px);background:#fff;border:1px solid var(--stroke);border-radius:16px;box-shadow:0 18px 40px rgba(16,24,40,.12);overflow:hidden;min-width:235px;display:none;z-index:30}
    .menuPanel button{width:100%;border:0;background:#fff;padding:12px;text-align:left;cursor:pointer;font-weight:950;display:flex;align-items:center;gap:10px}
    .menuPanel button:hover{background:rgba(124,58,237,.06)}
    .rowIconWrap{width:22px;height:22px;border-radius:999px;overflow:hidden;border:1px solid rgba(0,0,0,.08);background:#fff;display:grid;place-items:center;flex:0 0 auto}
    .rowIconWrap img{width:100%;height:100%;object-fit:cover;display:block}
    .rowIconWrap svg{width:14px;height:14px;color:var(--brand)}
    .fxRow{display:flex;align-items:center;justify-content:flex-start;gap:10px;padding:10px 4px 2px;color:var(--brand);font-weight:950;font-size:14px}
    .fxRow .bell{width:18px;height:18px;color:var(--brand)}
    .note{background:var(--soft);border:1px solid var(--stroke);border-radius:14px;padding:12px;color:var(--muted);font-size:13px;line-height:1.45;margin-top:10px}
    .sectionTitle{margin:14px 2px 6px;font-size:13px;letter-spacing:1.2px;font-weight:950;color:var(--muted)}
    .selectRow{display:flex;align-items:center;justify-content:space-between;gap:10px;border:1px solid var(--stroke);border-radius:18px;padding:16px 14px;background:var(--soft);cursor:pointer;user-select:none}
    .selectRow .left{display:flex;align-items:center;gap:10px;font-weight:950}
    .iconBadge{width:34px;height:34px;border-radius:12px;background:rgba(124,58,237,.10);display:grid;place-items:center;color:var(--brand);flex:0 0 auto;overflow:hidden}
    .iconBadge img{width:100%;height:100%;object-fit:cover;display:block}
    .iconBadge svg{width:18px;height:18px}
    .footerBar{position:fixed;left:0;right:0;bottom:0;display:flex;justify-content:center;padding:12px 14px calc(14px + var(--safeBottom));background:linear-gradient(to top, rgba(255,255,255,1), rgba(255,255,255,.88));border-top:1px solid rgba(230,232,238,.6);z-index:40}
    .footerInner{width:min(var(--maxw),100%)}
    .rowLine{display:flex;justify-content:space-between;align-items:center;padding:10px 2px;font-weight:950;font-size:15px}
    .rowLine .muted{color:var(--muted);font-weight:900}
    .linkRow{display:flex;justify-content:space-between;align-items:center;padding:8px 2px 6px;color:var(--brand);font-weight:950;cursor:pointer;user-select:none;font-size:15px}
    .linkRow svg{width:18px;height:18px}
    .total{display:flex;justify-content:space-between;align-items:flex-end;padding:12px 2px 12px;font-weight:950}
    .total .big{color:var(--brand);font-size:24px;letter-spacing:-.2px}
    .btn{width:100%;border:0;padding:16px 14px;border-radius:18px;background:var(--brand);color:#fff;font-weight:950;font-size:16px;cursor:pointer;box-shadow:0 16px 30px rgba(124,58,237,.24);transition:transform .12s ease, filter .12s ease}
    .btn:hover{transform:translateY(-1px);filter:brightness(1.02)}
    .toast{position:fixed;left:50%;transform:translateX(-50%);bottom:calc(132px + var(--safeBottom));background:rgba(17,24,39,.92);color:#fff;padding:10px 12px;border-radius:14px;font-size:12.5px;font-weight:900;box-shadow:0 18px 40px rgba(0,0,0,.25);opacity:0;pointer-events:none;transition:opacity .2s ease, transform .2s ease;z-index:60}
    .toast.show{opacity:1;transform:translateX(-50%) translateY(-2px)}
  
    /* Premium currency picker overlay (prevents overlap/clipping) */
    .curOverlay{position:fixed;inset:0;z-index:9999;display:none}
    .curOverlay.show{display:block}
    .curBackdrop{position:absolute;inset:0;background:rgba(15,23,42,.28)}
    .curSheet{
      position:absolute;
      width:min(520px, calc(100vw - 18px));
      background:#fff;
      border:1px solid var(--stroke);
      border-radius:18px;
      box-shadow:0 30px 70px rgba(2,6,23,.22);
      overflow:hidden;
    }
    .curHead{
      padding:12px 14px 10px;
      font-weight:950;
      color:#0f172a;
      border-bottom:1px solid rgba(15,23,42,.08);
      background:rgba(124,58,237,.04);
    }
    .curList{padding:10px;display:grid;gap:8px}
    .curItem{
      border:1px solid rgba(15,23,42,.10);
      background:#fff;
      border-radius:14px;
      padding:12px 12px;
      display:flex;align-items:center;gap:12px;
      cursor:pointer;
    }
    .curItem:hover{background:rgba(124,58,237,.06)}
    .curItem:active{transform:scale(.995)}
    .curIcon{width:34px;height:34px;border-radius:999px;overflow:hidden;background:rgba(124,58,237,.06);display:grid;place-items:center;flex:0 0 auto}
    .curIcon img{width:100%;height:100%;object-fit:cover;display:block}
    .curTxt{min-width:0}
    .curCode{font-weight:950;font-size:18px;line-height:1.1}
    .curSub{color:var(--muted);font-weight:900;font-size:13px;margin-top:2px}

  </style>
</head>
<body>
<div class="wrap"><div class="shell">

  <div class="top">
    <button class="back" onclick="history.back()" aria-label="Back">
      <svg viewBox="0 0 24 24" fill="none">
        <path d="M15 18l-6-6 6-6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
      </svg>
    </button>
    <div>
      <h1>Send money</h1>
      <div class="sub">Welcome, <?= htmlspecialchars($_SESSION['user_name']) ?> — live FX + fees + promo</div>
    </div>
  </div>

  <div class="card">
    <div class="fieldBox">
      <div class="fieldLeft">
        <div class="label">You send</div>
        <input class="amount" id="sendAmount" inputmode="decimal" placeholder="0.00" value="97.27"/>
      </div>

      <div class="menu">
        <div class="pill" id="sendCurBtn" aria-label="Send currency">
          <span class="iconWrap" id="sendIconWrap"><img id="sendImg" alt="currency"/></span>
          <b id="sendCurText">USDT</b>
          <svg class="chev" viewBox="0 0 24 24" fill="none">
            <path d="M7 10l5 5 5-5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
          </svg>
        </div>
</div>
    </div>

    <div class="fxRow">
      <span id="fxLine">1.00 USDT = 1.0000 USD</span>
      <svg class="bell" viewBox="0 0 24 24" fill="none" aria-hidden="true">
        <path d="M18 8a6 6 0 10-12 0c0 7-3 7-3 7h18s-3 0-3-7" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        <path d="M13.7 21a2 2 0 01-3.4 0" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
      </svg>
    </div>

    <div class="fieldBox" style="margin-top:12px;">
      <div class="fieldLeft">
        <div class="label">They receive</div>
        <input class="amount" id="receiveAmount" inputmode="decimal" placeholder="0.00" value="110.00"/>
      </div>

      <div class="pill" style="min-width:165px;" aria-label="Receive currency">
        <span class="iconWrap" id="zimIconWrap"><img id="zimImg" alt="Zimbabwe"/></span>
        <b>USD</b>
        <svg class="chev" viewBox="0 0 24 24" fill="none">
          <path d="M7 10l5 5 5-5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
      </div>
    </div>

    <div class="note" id="roundNote">Live FX applied. Receive amount updates instantly.</div>
  </div>

  <?php include __DIR__ . '/components/receive_method.php'; ?>

  <form method="POST" id="sendForm" action="next.php" style="display:none;">
    <input type="hidden" name="send_currency" id="f_send_currency" value="USDT"/>
    <input type="hidden" name="send_amount" id="f_send_amount" value="97.27"/>
    <input type="hidden" name="receive_currency" id="f_receive_currency" value="USD"/>
    <input type="hidden" name="receive_amount" id="f_receive_amount" value="110.00"/>
    <input type="hidden" name="receive_method" id="f_receive_method" value="USDT"/>
    <input type="hidden" name="promo_code" id="f_promo_code" value=""/>
      <input type="hidden" name="fee_amount" id="f_fee_amount" value=""/>
    <input type="hidden" name="total_amount" id="f_total_amount" value=""/>
</form>

</div></div>

<div class="footerBar">
  <div class="footerInner">
    <div class="rowLine">
      <div class="muted">Transfer fees</div>
      <div id="feeText">2.99 USDT</div>
    </div>

    <?php include __DIR__ . '/components/promo_code.php'; ?>

    <div class="total">
      <div class="muted">Total amount</div>
      <div class="big" id="totalText">100.26 USDT</div>
    </div>

    <button class="btn" id="nextBtn">Next</button>
  </div>
</div>


<!-- Currency picker overlay -->
<div class="curOverlay" id="curOverlay" aria-hidden="true">
  <div class="curBackdrop" id="curBackdrop"></div>
  <div class="curSheet" id="curSheet" role="listbox" aria-label="Send currency">
    <div class="curHead">Choose currency</div>
    <div class="curList" id="curList"></div>
  </div>
</div>

<div class="toast" id="toast"></div>

<script>
  window.__fallbackIcon = function(label){
    return `
      <svg viewBox="0 0 24 24" fill="none" aria-hidden="true">
        <rect x="3" y="3" width="18" height="18" rx="6" stroke="currentColor" stroke-width="2"/>
        <path d="M8 12h8" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
        <path d="M9 9h6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
      </svg>
    `;
  };

  function setIcon(imgEl, wrapEl, url, fallbackKey){
    imgEl.src = url;
    imgEl.onload = () => {};
    imgEl.onerror = () => { wrapEl.innerHTML = window.__fallbackIcon(fallbackKey); };
  }

  const toastEl = document.getElementById("toast");
  function toast(msg){
    toastEl.textContent = msg;
    toastEl.classList.add("show");
    clearTimeout(window.__t);
    window.__t = setTimeout(()=>toastEl.classList.remove("show"), 1200);
    if ("vibrate" in navigator) navigator.vibrate(12);
  }
  function parseAmt(v){ const x = String(v).replace(/[^0-9.]/g,""); return Math.max(0, Number(x || 0)); }
  function fmt2(n){ return (Math.round(n*100)/100).toFixed(2); }
  function fmt4(n){ return (Math.round(n*10000)/10000).toFixed(4); }

  let sendCur = "USDT";
  let fxSendToUSD = 1;
  let lastRates = null;
  let promoCode = "";
  let lastEdited = "send";

  const sendAmountEl = document.getElementById("sendAmount");
  const receiveAmountEl = document.getElementById("receiveAmount");
  const fxLineEl = document.getElementById("fxLine");
  const feeTextEl = document.getElementById("feeText");
  const totalTextEl = document.getElementById("totalText");
  const roundNoteEl = document.getElementById("roundNote");

  const sendCurBtn = document.getElementById("sendCurBtn");
const sendCurText = document.getElementById("sendCurText");
  const sendIconWrap = document.getElementById("sendIconWrap");

  const zimImg = document.getElementById("zimImg");
  const zimIconWrap = document.getElementById("zimIconWrap");

  const methodBtn = document.getElementById("methodBtn");
const methodText = document.getElementById("methodText");
  const methodIcon = document.getElementById("methodIcon");

  const fSendCur = document.getElementById("f_send_currency");
  const fSendAmt = document.getElementById("f_send_amount");
  const fRecvCur = document.getElementById("f_receive_currency");
  const fRecvAmt = document.getElementById("f_receive_amount");
  const fMethod  = document.getElementById("f_receive_method");
  const fPromo   = document.getElementById("f_promo_code");

  
  const fFeeAmt = document.getElementById("f_fee_amount");
  const fTotalAmt = document.getElementById("f_total_amount");
// Init icons
  setIcon(document.getElementById("sendImg"), sendIconWrap, "https://i.imgur.com/rDkAovM.png", "USDT");
  setIcon(zimImg, zimIconWrap, "https://i.imgur.com/WMdMxPI.png", "ZIM");

  // Premium currency picker (fixed overlay so it never overlaps/clips)
  const curOverlay = document.getElementById("curOverlay");
  const curBackdrop = document.getElementById("curBackdrop");
  const curSheet = document.getElementById("curSheet");
  const curList = document.getElementById("curList");

  const CURRENCIES = [
    { cur:"USDT", icon:"https://i.imgur.com/rDkAovM.png", name:"Stablecoin" },
    { cur:"USD",  icon:"https://i.imgur.com/X1kw5aO.png", name:"US Dollar" },
    { cur:"EUR",  icon:"https://i.imgur.com/Dc00hbM.png", name:"Euro" },
    { cur:"GBP",  icon:"https://i.imgur.com/RcORDlF.png", name:"British Pound" },
  ];

  function openCurrencyPicker(){
    // Build list
    curList.innerHTML = "";
    CURRENCIES.forEach(it=>{
      const row = document.createElement("div");
      row.className = "curItem";
      row.innerHTML = `
        <div class="curIcon"><img src="${it.icon}" alt="${it.cur}"></div>
        <div class="curTxt">
          <div class="curCode">${it.cur}</div>
          <div class="curSub">${it.name}</div>
        </div>
      `;
      row.addEventListener("click", async ()=>{
        closeCurrencyPicker();
        sendCur = it.cur;
        sendCurText.textContent = sendCur;

        // Update pill icon
        sendIconWrap.innerHTML = '<img id="sendImg" alt="currency"/>';
        const newImg = document.getElementById("sendImg");
        setIcon(newImg, sendIconWrap, it.icon, sendCur);

        await refreshFx();
        recalcFromSend();
        toast("Currency set to " + sendCur);
      });
      curList.appendChild(row);
    });

    // Position sheet under the pill (open upward if needed)
    const rect = sendCurBtn.getBoundingClientRect();
    const maxW = Math.min(520, window.innerWidth - 18);
    curSheet.style.width = maxW + "px";

    const left = Math.max(9, Math.min(window.innerWidth - maxW - 9, rect.left));
    let top = rect.bottom + 10;

    const estimatedH = 330;
    if (top + estimatedH > window.innerHeight - 10) {
      top = Math.max(10, rect.top - estimatedH - 10);
    }

    curSheet.style.left = left + "px";
    curSheet.style.top  = top + "px";

    curOverlay.classList.add("show");
    curOverlay.setAttribute("aria-hidden","false");
  }

  function closeCurrencyPicker(){
    curOverlay.classList.remove("show");
    curOverlay.setAttribute("aria-hidden","true");
  }

  curBackdrop.addEventListener("click", closeCurrencyPicker);
  sendCurBtn.addEventListener("click", (e)=>{ e.preventDefault(); e.stopPropagation(); openCurrencyPicker(); });

  document.addEventListener("keydown", (e)=>{ if(e.key==="Escape") closeCurrencyPicker(); });
  window.addEventListener("resize", ()=>{ if(curOverlay.classList.contains("show")) openCurrencyPicker(); });

  async function fetchRates(){
    const fallback = { date:"offline", base:"EUR", rates:{ USD:1.10, GBP:0.86, ZAR:20.50 } };
    try{
      const res = await fetch("https://api.frankfurter.dev/v1/latest?base=EUR&symbols=USD,GBP,ZAR", { cache:"no-store" });
      if(!res.ok) throw new Error("HTTP " + res.status);
      return await res.json();
    }catch(err){
      return fallback;
    }
  }

  function computeFxSendToUSD(){
    if (sendCur === "USDT") return 1;
    const EURUSD = Number(lastRates.rates.USD);
    const EURGBP = Number(lastRates.rates.GBP);
    const EURZAR = Number(lastRates.rates.ZAR);
    if (sendCur === "USD") return 1;
    if (sendCur === "EUR") return EURUSD;
    if (sendCur === "GBP") return EURUSD / EURGBP;
    if (sendCur === "ZAR") return EURUSD / EURZAR;
    return 1;
  }

  async function refreshFx(){
    if (sendCur === "USDT") {
      fxSendToUSD = 1;
      fxLineEl.textContent = "1.00 USDT = 1.0000 USD";
      return;
    }
    lastRates = await fetchRates();
    fxSendToUSD = computeFxSendToUSD();
    fxLineEl.textContent = "1.00 " + sendCur + " = " + fmt4(fxSendToUSD) + " USD";
  }

  function feeInSendCurrency(){
    const baseFeeUSD = 2.99;
    let fee = baseFeeUSD;
    const p = promoCode.trim().toUpperCase();
    if (p === "NOFEE") fee = 0;
    if (p === "SAVE50") fee = fee * 0.5;
    if (sendCur === "USDT" || sendCur === "USD") return fee;
    if (!fxSendToUSD || fxSendToUSD <= 0) return fee;
    return fee / fxSendToUSD;
  }

  function updateFeeAndTotal(){
    const sendAmt = parseAmt(sendAmountEl.value);
    const fee = feeInSendCurrency();
    feeTextEl.textContent = fmt2(fee) + " " + sendCur;
    totalTextEl.textContent = fmt2(sendAmt + fee) + " " + sendCur;
  }

  function recalcFromSend(){
    const sendAmt = parseAmt(sendAmountEl.value);
    const recv = sendAmt * fxSendToUSD;
    receiveAmountEl.value = fmt2(recv);
    roundNoteEl.textContent = "Live FX applied. Receiver gets approximately " + fmt2(recv) + " USD.";
    updateFeeAndTotal();
    syncForm();
  }

  function recalcFromReceive(){
    const recvAmt = parseAmt(receiveAmountEl.value);
    if (!fxSendToUSD || fxSendToUSD <= 0) return;
    const send = recvAmt / fxSendToUSD;
    sendAmountEl.value = fmt2(send);
    roundNoteEl.textContent = "Live FX applied. You send approximately " + fmt2(send) + " " + sendCur + ".";
    updateFeeAndTotal();
    syncForm();
  }

  sendAmountEl.addEventListener("input", ()=>{ lastEdited="send"; recalcFromSend(); });
  receiveAmountEl.addEventListener("input", ()=>{ lastEdited="receive"; recalcFromReceive(); });
// Promo code hook (UI is in separate file)
  document.getElementById("promoRow").addEventListener("click", ()=>{
    const input = prompt("Enter promo code (demo: SAVE50 or NOFEE):", promoCode || "");
    if (input === null) return;
    promoCode = input.trim();
    document.getElementById("promoStatus").textContent = promoCode ? promoCode : "Add";
    toast(promoCode ? ("Promo: " + promoCode) : "Promo cleared");
    updateFeeAndTotal();
    syncForm();
  });

  
  // Called by the Receive Method bottom-sheet (components/receive_method.php)
  window.onReceiveMethodChange = function(method){
    // Recompute totals (fees are still computed in send currency for now)
    updateFeeAndTotal();
    syncForm();
  };

function syncForm(){
    fSendCur.value = sendCur;
    fSendAmt.value = fmt2(parseAmt(sendAmountEl.value));
    fRecvCur.value = "USD";
    fRecvAmt.value = fmt2(parseAmt(receiveAmountEl.value));
    fMethod.value  = methodText.textContent.trim();
    fPromo.value   = promoCode;
    if (fFeeAmt) fFeeAmt.value = fmt2(feeInSendCurrency());
    if (fTotalAmt) fTotalAmt.value = fmt2(parseAmt(sendAmountEl.value) + feeInSendCurrency());
  }

  document.getElementById("nextBtn").addEventListener("click", ()=>{
    syncForm();
    const s = parseAmt(sendAmountEl.value);
    const r = parseAmt(receiveAmountEl.value);
    if (s <= 0 && r <= 0) { toast("Enter an amount"); return; }
    document.getElementById("sendForm").submit();
  });

  (async function init(){
    await refreshFx();
    recalcFromSend();
    setInterval(async ()=>{
      await refreshFx();
      if (lastEdited === "send") recalcFromSend(); else recalcFromReceive();
    }, 60000);
  })();
</script>
</body>
</html>
