<?php
declare(strict_types=1);
require_once __DIR__ . '/../backend/lib/auth.php';
require_once __DIR__ . '/../backend/models/transfers.php';
$u = require_login();

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
$rows = list_transfers_for_user((int)$u['id']);
?>
<!doctype html><html><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover"/>
<link rel="stylesheet" href="../assets/app.css"/>
<title>Transfers</title>
<style>
  .titem{border:1px solid rgba(15,23,42,.10);border-radius:18px;padding:14px;background:#fff}
  .pill{display:inline-flex;padding:6px 10px;border-radius:999px;border:1px solid rgba(124,58,237,.18);background:rgba(124,58,237,.08);font-weight:950;color:#5b21b6;font-size:12px}
  .meta{color:rgba(15,23,42,.62);font-weight:850;font-size:13px;margin-top:4px}
  .topRow{display:flex;align-items:flex-start;justify-content:space-between;gap:12px}
  .amt{font-weight:950;font-size:16px}
</style>
</head><body>
<div class="app"><div class="shell">
  <div class="topbar">
    <div class="brand"><div class="sub">Transfers</div></div>
    <div class="icons">
      <a class="iconbtn" href="../settings/index.html" aria-label="Settings" title="Settings">
        <svg viewBox="0 0 24 24" fill="none"><path d="M12 15.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7Z" stroke="currentColor" stroke-width="2"/><path d="M19.4 15a7.8 7.8 0 0 0 .1-2l2-1.5-2-3.5-2.4 1a8 8 0 0 0-1.7-1L15 4h-6l-.4 2.5c-.6.3-1.2.6-1.7 1l-2.4-1-2 3.5 2 1.5a7.8 7.8 0 0 0 0 2l-2 1.5 2 3.5 2.4-1c.5.4 1.1.7 1.7 1L9 20h6l.4-2.5c.6-.3 1.2-.6 1.7-1l2.4 1 2-3.5-2-1.5Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/></svg>
      </a>
    </div>
  </div>

  <div class="content">
    <?php if(!$rows): ?>
      <div class="card white">
        <div class="h2">No transfers yet</div>
        <p class="muted">Start your first transfer to Zimbabwe.</p>
        <a class="primaryBtn" href="../send/send.php" style="width:100%;text-align:center;text-decoration:none">Start transfer</a>
      </div>
    <?php else: ?>
      <div class="grid" style="gap:12px">
        <?php foreach($rows as $r): 
          $status = (string)$r['status'];
          $label = str_replace('_',' ', $status);
        ?>
          <div class="titem">
            <div class="topRow">
              <div>
                <div style="font-weight:950;letter-spacing:-.2px">
                  <?= h($r['receiver_name'] ?? 'Receiver') ?>
                </div>
                <div class="meta">
                  <?= h($r['receive_method']) ?> • <?= h($r['receive_currency']) ?> • Rate <?= h($r['fx_rate']) ?>
                </div>
              </div>
              <div style="text-align:right">
                <div class="amt"><?= h($r['send_amount']) ?> <?= h($r['send_currency']) ?></div>
                <div class="meta">Fee <?= h($r['fee_amount']) ?> <?= h($r['send_currency']) ?></div>
              </div>
            </div>
            <div style="display:flex;justify-content:space-between;align-items:center;margin-top:10px;gap:10px">
              <span class="pill"><?= h(ucwords($label)) ?></span>
              <div class="meta">You receive: <span style="font-weight:950"><?= h($r['receive_amount']) ?> <?= h($r['receive_currency']) ?></span></div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>

  <?php include __DIR__ . '/../partials/bottom_nav.php'; ?>
</div></div>
<script src="../assets/app.js"></script>
<script>SendZim.setActiveNav("transfers");SendZim.setUserUI();</script>
</body></html>
